/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.computers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.QualifierCompletionProposal;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class QualifierCompletionProposalComputer
extends JavaCompletionProposalComputer {
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        JavaContentAssistInvocationContext javaContext;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (context instanceof JavaContentAssistInvocationContext && SpringCoreUtils.isSpringProject((IResource)(javaContext = (JavaContentAssistInvocationContext)context).getProject().getProject())) {
            ITextViewer viewer = javaContext.getViewer();
            IDocument document = viewer.getDocument();
            try {
                String annotation;
                int invocationOffset;
                int start = invocationOffset = context.getInvocationOffset();
                int end = invocationOffset;
                while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                    --start;
                }
                if (start > 0 && document.getChar(start - 1) == '@' && "qualifier".startsWith((annotation = document.get(start, end - start)).toLowerCase()) && viewer instanceof ISourceViewer) {
                    SingleVariableDeclaration variableDecl;
                    AssistContext assistContext = new AssistContext(javaContext.getCompilationUnit(), (ISourceViewer)viewer, start - 1, end - start + 1);
                    ASTNode annotationNode = assistContext.getCoveredNode();
                    BodyDeclaration decl = this.getParentDeclaration(annotationNode);
                    if (decl instanceof FieldDeclaration) {
                        proposals.add((ICompletionProposal)new QualifierCompletionProposal(annotationNode, decl, javaContext));
                    } else if (decl instanceof MethodDeclaration && (variableDecl = this.getParentVariableDeclaration(annotationNode)) != null) {
                        proposals.add((ICompletionProposal)new QualifierCompletionProposal(annotationNode, decl, javaContext));
                    }
                }
            }
            catch (BadLocationException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.quickfix", e.getMessage(), (Throwable)e));
            }
        }
        return proposals;
    }

    private BodyDeclaration getParentDeclaration(ASTNode node) {
        if (node == null || node instanceof BodyDeclaration) {
            return (BodyDeclaration)node;
        }
        return this.getParentDeclaration(node.getParent());
    }

    private SingleVariableDeclaration getParentVariableDeclaration(ASTNode node) {
        if (node == null || node instanceof SingleVariableDeclaration) {
            return (SingleVariableDeclaration)node;
        }
        return this.getParentVariableDeclaration(node.getParent());
    }
}

