/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.ProjectAwareUrlStreamHandlerService;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.DocumentAccessor;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.ProjectClasspathUriResolver;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.SpringCorePreferences;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.Document;

public class ProjectClasspathExtensibleUriResolver
implements URIResolverExtension,
IElementChangedListener,
Preferences.IPropertyChangeListener,
IEclipsePreferences.IPreferenceChangeListener {
    private static final String KEY_DISABLE_CACHING_PREFERENCE = "org.springframework.ide.eclipse.beans.core.disableCachingForNamespaceLoadingFromClasspath";
    private static ConcurrentMap<IProject, Future<ProjectClasspathUriResolver>> projectResolvers = new ConcurrentHashMap<IProject, Future<ProjectClasspathUriResolver>>();

    public ProjectClasspathExtensibleUriResolver() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        BeansCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public String resolve(IFile file, String baseLocation, String publicId, String systemId) {
        if (systemId != null && systemId.startsWith("jar:")) {
            return null;
        }
        IProject project = null;
        if (file != null) {
            project = this.getBestMatchingProject(file);
        } else if (baseLocation != null && baseLocation.startsWith("project-aware://")) {
            String nameAndLocation = baseLocation.substring("project-aware://".length());
            String projectName = nameAndLocation.substring(0, nameAndLocation.indexOf(47));
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project == null || BeansCorePlugin.getModel().getProject(project) == null) {
            return null;
        }
        if (systemId == null && file != null) {
            systemId = this.findSystemIdFromFile(file, publicId);
        }
        if (systemId == null && publicId == null) {
            return null;
        }
        ProjectClasspathUriResolver resolver = this.getProjectResolver(file, project);
        if (resolver != null) {
            String resolved = resolver.resolveOnClasspath(publicId, systemId);
            if (resolved != null) {
                resolved = ProjectAwareUrlStreamHandlerService.createProjectAwareUrl(project.getName(), resolved);
            }
            return resolved;
        }
        return null;
    }

    private IProject getBestMatchingProject(IFile file) {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.getLocationURI());
        if (files != null && files.length == 1) {
            return files[0].getProject();
        }
        if (files != null && files.length > 1) {
            IFile shortestPathFile = files[0];
            int shortestPathSegmentCount = shortestPathFile.getFullPath().segmentCount();
            int i = 1;
            while (i < files.length) {
                int segmentCount = files[i].getFullPath().segmentCount();
                if (segmentCount < shortestPathSegmentCount) {
                    shortestPathFile = files[i];
                    shortestPathSegmentCount = segmentCount;
                }
                ++i;
            }
            return shortestPathFile.getProject();
        }
        return null;
    }

    private ProjectClasspathUriResolver getProjectResolver(IFile file, final IProject project) {
        Callable<ProjectClasspathUriResolver> createResolver;
        FutureTask<ProjectClasspathUriResolver> futureTask;
        IBeansProject beansProject = BeansCorePlugin.getModel().getProject(project);
        if (beansProject == null) {
            return null;
        }
        if (!NamespaceUtils.useNamespacesFromClasspath(project)) {
            return null;
        }
        if (file != null && !this.checkFileExtension(file, beansProject)) {
            return null;
        }
        FutureTask<ProjectClasspathUriResolver> future = (FutureTask<ProjectClasspathUriResolver>)projectResolvers.get(project);
        if (future == null && (future = (Future)projectResolvers.putIfAbsent(project, futureTask = new FutureTask<ProjectClasspathUriResolver>(createResolver = new Callable<ProjectClasspathUriResolver>(){

            @Override
            public ProjectClasspathUriResolver call() throws InterruptedException {
                ProjectClasspathUriResolver resolver = new ProjectClasspathUriResolver(project);
                SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.beans.core").getProjectPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)ProjectClasspathExtensibleUriResolver.this);
                return resolver;
            }
        }))) == null) {
            future = futureTask;
            futureTask.run();
        }
        try {
            return (ProjectClasspathUriResolver)future.get();
        }
        catch (CancellationException cancellationException) {
            projectResolvers.remove(project, future);
            return null;
        }
        catch (ExecutionException executionException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            if ((delta.getFlags() & 0x200000) != 0 || (delta.getFlags() & 0x20000) != 0) {
                this.resetForChangedElement(delta.getElement());
            } else if ((delta.getFlags() & 0x400) != 0) {
                this.resetForChangedElement(delta.getElement());
            } else if ((delta.getFlags() & 0x200) != 0) {
                this.resetForChangedElement(delta.getElement());
            } else if ((delta.getKind() & 2) != 0) {
                this.resetForChangedElement(delta.getElement());
            } else if ((delta.getKind() & 1) != 0) {
                this.resetForChangedElement(delta.getElement());
            }
            ++n2;
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if ("disableCachingForNamespaceLoadingFromClasspath".equals(event.getProperty())) {
            projectResolvers.clear();
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (KEY_DISABLE_CACHING_PREFERENCE.equals(event.getKey())) {
            projectResolvers.clear();
        }
    }

    private void resetForChangedElement(IJavaElement element) {
        if (element instanceof IJavaProject) {
            IProject project = ((IJavaProject)element).getProject();
            projectResolvers.remove(project);
            SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.beans.core").getProjectPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        for (IProject project : projectResolvers.keySet()) {
            IJavaProject javaProject = JdtUtils.getJavaProject((IProject)project);
            if (javaProject == null || !javaProject.isOnClasspath(element)) continue;
            projectResolvers.remove(project);
            SpringCorePreferences.getProjectPreferences((IProject)project, (String)"org.springframework.ide.eclipse.beans.core").getProjectPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String findSystemIdFromFile(IFile file, String publicIc) {
        String location;
        InputStream contents = null;
        contents = file.getContents();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(false);
        builderFactory.setNamespaceAware(true);
        builderFactory.setFeature("http://xml.org/sax/features/validation", false);
        builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document doc = builder.parse(contents);
        DocumentAccessor accessor = new DocumentAccessor();
        accessor.pushDocument(doc);
        DocumentAccessor.SchemaLocations locations = accessor.getCurrentSchemaLocations();
        String string = location = locations.getSchemaLocation(publicIc);
        if (contents == null) return string;
        try {
            contents.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception exception) {
            try {
                if (contents == null) return null;
            }
            catch (Throwable throwable) {
                if (contents == null) throw throwable;
                try {
                    contents.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                contents.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    private boolean checkFileExtension(IFile file, IBeansProject project) {
        if (project.getConfigSuffixes() != null) {
            for (String extension : project.getConfigSuffixes()) {
                if (!file.getName().endsWith(extension)) continue;
                return true;
            }
        }
        return file.getName().endsWith(".xsd");
    }
}

