/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StringMatcher;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SuiteListSelectionDialog
extends SelectionDialog {
    private static final String DIALOG_SETTINGS_SECTION = "ResourceListSelectionDialogSettings";
    Table resourceNames;
    Table folderNames;
    int typeMask;
    private static Collator collator = Collator.getInstance();
    StringMatcher stringMatcher;
    ResourceDescriptor[] descriptors;
    int descriptorsSize;
    WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    boolean okEnabled = false;

    public SuiteListSelectionDialog(Shell parentShell, IResource[] resources) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initDescriptors(resources);
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    public boolean close() {
        boolean result = super.close();
        this.labelProvider.dispose();
        return result;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(this.okEnabled);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Label l = new Label(dialogArea, 0);
        l = new Label(dialogArea, 0);
        l.setText(IDEWorkbenchMessages.ResourceSelectionDialog_matching);
        GridData data = new GridData(768);
        l.setLayoutData((Object)data);
        this.resourceNames = new Table(dialogArea, 2564);
        data = new GridData(1808);
        data.heightHint = 12 * this.resourceNames.getItemHeight();
        this.resourceNames.setLayoutData((Object)data);
        l = new Label(dialogArea, 0);
        l.setText(IDEWorkbenchMessages.ResourceSelectionDialog_folders);
        data = new GridData(768);
        l.setLayoutData((Object)data);
        this.folderNames = new Table(dialogArea, 2820);
        data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 4 * this.folderNames.getItemHeight();
        this.folderNames.setLayoutData((Object)data);
        this.resourceNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SuiteListSelectionDialog.this.updateFolders((ResourceDescriptor)e.item.getData());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SuiteListSelectionDialog.this.okPressed();
            }
        });
        this.folderNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SuiteListSelectionDialog.this.okPressed();
            }
        });
        SuiteListSelectionDialog.applyDialogFont((Control)dialogArea);
        return dialogArea;
    }

    private Image getImage(ResourceDescriptor desc) {
        IResource r = (IResource)desc.resources.get(0);
        return this.labelProvider.getImage((Object)r);
    }

    private Image getParentImage(IResource resource) {
        IContainer parent = resource.getParent();
        return this.labelProvider.getImage((Object)parent);
    }

    private String getParentLabel(IResource resource) {
        IContainer parent = resource.getParent();
        String text = parent.getType() == 8 ? this.labelProvider.getText((Object)parent) : parent.getFullPath().makeRelative().toString();
        if (text == null) {
            return "";
        }
        return text;
    }

    private void initDescriptors(final IResource[] resources) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                SuiteListSelectionDialog.this.descriptors = new ResourceDescriptor[resources.length];
                int i = 0;
                while (i < resources.length) {
                    IResource r = resources[i];
                    ResourceDescriptor d = new ResourceDescriptor();
                    d.label = r.getName();
                    d.resources.add(r);
                    SuiteListSelectionDialog.this.descriptors[i] = d;
                    ++i;
                }
                Arrays.sort(SuiteListSelectionDialog.this.descriptors);
                SuiteListSelectionDialog.this.descriptorsSize = SuiteListSelectionDialog.this.descriptors.length;
                int index = 0;
                if (SuiteListSelectionDialog.this.descriptorsSize < 2) {
                    return;
                }
                ResourceDescriptor current = SuiteListSelectionDialog.this.descriptors[index];
                IResource currentResource = (IResource)current.resources.get(0);
                int i2 = 1;
                while (i2 < SuiteListSelectionDialog.this.descriptorsSize) {
                    ResourceDescriptor next = SuiteListSelectionDialog.this.descriptors[i2];
                    IResource nextResource = (IResource)next.resources.get(0);
                    if (nextResource.getType() == currentResource.getType() && next.label.equals(current.label)) {
                        current.resources.add(nextResource);
                        current.resourcesSorted = false;
                    } else {
                        if (current.resources.size() > 1) {
                            current.resourcesSorted = false;
                        }
                        SuiteListSelectionDialog.this.descriptors[index + 1] = SuiteListSelectionDialog.this.descriptors[i2];
                        current = SuiteListSelectionDialog.this.descriptors[++index];
                        currentResource = (IResource)current.resources.get(0);
                    }
                    ++i2;
                }
                SuiteListSelectionDialog.this.descriptorsSize = index + 1;
            }
        });
    }

    protected void okPressed() {
        TableItem[] items = this.folderNames.getSelection();
        if (items.length == 1) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(items[0].getData());
            this.setResult(result);
        }
        super.okPressed();
    }

    protected boolean select(IResource resource) {
        return true;
    }

    private void updateFolders(final ResourceDescriptor desc) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!desc.resourcesSorted) {
                    Collections.sort(desc.resources, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            String s1 = SuiteListSelectionDialog.this.getParentLabel((IResource)o1);
                            String s2 = SuiteListSelectionDialog.this.getParentLabel((IResource)o2);
                            return collator.compare(s1, s2);
                        }
                    });
                    desc.resourcesSorted = true;
                }
                SuiteListSelectionDialog.this.folderNames.removeAll();
                int i = 0;
                while (i < desc.resources.size()) {
                    TableItem newItem = new TableItem(SuiteListSelectionDialog.this.folderNames, 0);
                    IResource r = (IResource)desc.resources.get(i);
                    newItem.setText(SuiteListSelectionDialog.this.getParentLabel(r));
                    newItem.setImage(SuiteListSelectionDialog.this.getParentImage(r));
                    newItem.setData((Object)r);
                    ++i;
                }
                SuiteListSelectionDialog.this.folderNames.setSelection(0);
            }
        });
    }

    private void updateItem(int index, int itemPos, int itemCount) {
        ResourceDescriptor desc = this.descriptors[index];
        if (itemPos < itemCount) {
            TableItem item = this.resourceNames.getItem(itemPos);
            if (item.getData() != desc) {
                item.setText(desc.label);
                item.setData((Object)desc);
                item.setImage(this.getImage(desc));
                if (itemPos == 0) {
                    this.resourceNames.setSelection(0);
                    this.updateFolders(desc);
                }
            }
        } else {
            TableItem item = new TableItem(this.resourceNames, 0);
            item.setText(desc.label);
            item.setData((Object)desc);
            item.setImage(this.getImage(desc));
            if (itemPos == 0) {
                this.resourceNames.setSelection(0);
                this.updateFolders(desc);
            }
        }
        this.updateOKState(true);
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        int i = 0;
        while (i < this.descriptorsSize) {
            this.updateItem(i, i, 0);
            ++i;
        }
        return ctrl;
    }

    protected void updateOKState(boolean state) {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed() && state != this.okEnabled) {
            okButton.setEnabled(state);
            this.okEnabled = state;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    static class ResourceDescriptor
    implements Comparable {
        String label;
        ArrayList resources = new ArrayList();
        boolean resourcesSorted = true;

        ResourceDescriptor() {
        }

        public int compareTo(Object o) {
            return collator.compare(this.label, ((ResourceDescriptor)o).label);
        }
    }
}

