/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRunnable;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class CheckinResourcesCommand
implements ISVNCommand {
    protected IResource[] resources;
    protected String message;
    protected boolean keepLocks;
    protected int depth;
    protected SVNWorkspaceRoot root;
    private ISVNNotifyListener notifyListener;
    private String postCommitError;
    private boolean commitError;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public CheckinResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, int depth, String message, boolean keepLocks) {
        this.resources = resources;
        this.message = message;
        this.depth = depth;
        this.root = root;
        this.keepLocks = keepLocks;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        this.commitError = false;
        this.postCommitError = null;
        final ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(monitor, svnClient));
        try {
            ArrayList<IContainer> parentsList = new ArrayList<IContainer>();
            ArrayList<IProject> projectList = new ArrayList<IProject>();
            IResource[] iResourceArray = this.resources;
            int n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                IResource currentResource = iResourceArray[n];
                IProject project = currentResource.getProject();
                if (!projectList.contains(project)) {
                    projectList.add(project);
                }
                IContainer parent = currentResource.getParent();
                ISVNLocalResource svnParentResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)parent);
                while (parent.getType() != 8 && parent.getType() != 4 && !svnParentResource.hasRemote()) {
                    if (!this.inCommitList((IResource)parent)) {
                        parentsList.add(parent);
                    }
                    parent = parent.getParent();
                    svnParentResource = svnParentResource.getParent();
                }
                ++n;
            }
            int parents = parentsList.size();
            if (parents > 0) {
                this.depth = 0;
            }
            final File[] resourceFiles = new File[parents + this.resources.length];
            int i = 0;
            while (i < parents) {
                resourceFiles[i] = ((IResource)parentsList.get(i)).getLocation().toFile();
                ++i;
            }
            i = 0;
            int j = parents;
            while (i < this.resources.length) {
                resourceFiles[j] = this.resources[i].getLocation().toFile();
                ++i;
                ++j;
            }
            IProject[] projects = new IProject[projectList.size()];
            projectList.toArray(projects);
            ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])projects);
            SVNProviderPlugin.run(new ISVNRunnable(){

                public void run(final IProgressMonitor pm) throws SVNException {
                    try {
                        try {
                            CheckinResourcesCommand.this.notifyListener = new ISVNNotifyListener(){

                                public void logCommandLine(String commandLine) {
                                }

                                public void logCompleted(String message) {
                                }

                                public void logError(String message) {
                                }

                                public void logMessage(String message) {
                                    if (message.startsWith("Transmitting file data")) {
                                        pm.subTask(message);
                                    }
                                }

                                public void logRevision(long revision, String path) {
                                }

                                public void onNotify(File path, SVNNodeKind kind) {
                                }

                                public void setCommand(int command) {
                                }
                            };
                            pm.beginTask(null, resourceFiles.length);
                            pm.setTaskName("Checking in...");
                            svnClient.addNotifyListener((ISVNNotifyListener)CheckinResourcesCommand.this.operationResourceCollector);
                            svnClient.addNotifyListener(CheckinResourcesCommand.this.notifyListener);
                            if (svnClient.canCommitAcrossWC()) {
                                svnClient.commitAcrossWC(resourceFiles, CheckinResourcesCommand.this.message, CheckinResourcesCommand.this.depth == 2, CheckinResourcesCommand.this.keepLocks, true);
                            } else {
                                svnClient.commit(resourceFiles, CheckinResourcesCommand.this.message, CheckinResourcesCommand.this.depth == 2, CheckinResourcesCommand.this.keepLocks);
                            }
                            CheckinResourcesCommand.this.postCommitError = svnClient.getPostCommitError();
                        }
                        catch (SVNClientException e) {
                            CheckinResourcesCommand.this.commitError = true;
                            throw SVNException.wrapException((Exception)((Object)e));
                        }
                    }
                    finally {
                        pm.done();
                        if (svnClient != null) {
                            svnClient.removeNotifyListener((ISVNNotifyListener)CheckinResourcesCommand.this.operationResourceCollector);
                            svnClient.removeNotifyListener(CheckinResourcesCommand.this.notifyListener);
                            CheckinResourcesCommand.this.root.getRepository().returnSVNClient(svnClient);
                        }
                    }
                }
            }, rule, Policy.monitorFor(monitor));
        }
        catch (Throwable throwable) {
            OperationManager.getInstance().endOperation(true, this.operationResourceCollector.getOperationResources(), !this.commitError);
            throw throwable;
        }
        OperationManager.getInstance().endOperation(true, this.operationResourceCollector.getOperationResources(), !this.commitError);
    }

    private boolean inCommitList(IResource resource) {
        IResource[] iResourceArray = this.resources;
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            IResource checkResource = iResourceArray[n];
            if (checkResource.equals((Object)resource)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getPostCommitError() {
        return this.postCommitError;
    }
}

