/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.model;

import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Project
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String key;
    private String description;
    private String lead;
    private String projectUrl;
    private String url;
    private Component[] components;
    private Version[] versions;
    private IssueType[] issueTypes;
    private SecurityLevel[] securityLevels;
    private Map<String, IssueType> issueTypesById;
    private boolean details;

    public Project(String id) {
        this.id = id;
    }

    public Project() {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getLead() {
        return this.lead;
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Component getComponent(String name) {
        Component[] componentArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component.getName().equals(name)) {
                return component;
            }
            ++n2;
        }
        return null;
    }

    public Component[] getComponents() {
        return this.components;
    }

    public void setComponents(Component[] components) {
        this.components = components;
    }

    public Version getVersion(String name) {
        Version[] versionArray = this.versions;
        int n = this.versions.length;
        int n2 = 0;
        while (n2 < n) {
            Version version = versionArray[n2];
            if (version.getName().equals(name)) {
                return version;
            }
            ++n2;
        }
        return null;
    }

    public void setVersions(Version[] versions) {
        this.versions = versions;
    }

    public Version[] getReleasedVersions(boolean includeArchived) {
        ArrayList<Version> releasedVersions = new ArrayList<Version>();
        Version[] versionArray = this.versions;
        int n = this.versions.length;
        int n2 = 0;
        while (n2 < n) {
            Version version = versionArray[n2];
            if (version.isReleased() && (!version.isArchived() || includeArchived)) {
                releasedVersions.add(version);
            }
            ++n2;
        }
        return releasedVersions.toArray(new Version[releasedVersions.size()]);
    }

    public Version[] getUnreleasedVersions(boolean includeArchived) {
        ArrayList<Version> unreleasedVersions = new ArrayList<Version>();
        Version[] versionArray = this.versions;
        int n = this.versions.length;
        int n2 = 0;
        while (n2 < n) {
            Version version = versionArray[n2];
            if (!(version.isReleased() || version.isArchived() && !includeArchived)) {
                unreleasedVersions.add(version);
            }
            ++n2;
        }
        return unreleasedVersions.toArray(new Version[unreleasedVersions.size()]);
    }

    public Version[] getArchivedVersions() {
        ArrayList<Version> archivedVersions = new ArrayList<Version>();
        Version[] versionArray = this.versions;
        int n = this.versions.length;
        int n2 = 0;
        while (n2 < n) {
            Version version = versionArray[n2];
            if (version.isArchived()) {
                archivedVersions.add(version);
            }
            ++n2;
        }
        return archivedVersions.toArray(new Version[archivedVersions.size()]);
    }

    public Version[] getVersions() {
        return this.versions;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project that = (Project)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public IssueType[] getIssueTypes() {
        return this.issueTypes;
    }

    public void setIssueTypes(IssueType[] issueTypes) {
        this.issueTypes = issueTypes;
        this.issueTypesById = new HashMap<String, IssueType>();
        if (issueTypes != null) {
            IssueType[] issueTypeArray = issueTypes;
            int n = issueTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IssueType type = issueTypeArray[n2];
                this.issueTypesById.put(type.getId(), type);
                ++n2;
            }
        }
    }

    public SecurityLevel[] getSecurityLevels() {
        return this.securityLevels;
    }

    public void setSecurityLevels(SecurityLevel[] securityLevels) {
        this.securityLevels = securityLevels;
    }

    public void setDetails(boolean details) {
        this.details = details;
    }

    public boolean hasDetails() {
        return this.details;
    }

    public IssueType getIssueTypeById(String typeId) {
        if (this.issueTypesById != null) {
            return this.issueTypesById.get(typeId);
        }
        return null;
    }
}

