/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.xbean.classloader.NonLockingJarFileClassLoader;
import org.springframework.ide.eclipse.core.java.ProjectClassLoaderCache;

public class FilteringNonLockingJarFileClassLoader
extends NonLockingJarFileClassLoader {
    private static final Enumeration<URL> EMPTY_ENUMERATION = Collections.enumeration(new ArrayList());

    public FilteringNonLockingJarFileClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    public URL findResource(String resourceName) {
        if (ProjectClassLoaderCache.shouldFilter(resourceName)) {
            return null;
        }
        return super.findResource(resourceName);
    }

    public Enumeration<URL> findResources(String resourceName) throws IOException {
        if (ProjectClassLoaderCache.shouldFilter(resourceName)) {
            return EMPTY_ENUMERATION;
        }
        return super.findResources(resourceName);
    }

    public URL getResource(String name) {
        if (ProjectClassLoaderCache.shouldFilter(name)) {
            return null;
        }
        return super.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        if (ProjectClassLoaderCache.shouldFilter(name)) {
            return null;
        }
        return super.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        if (ProjectClassLoaderCache.shouldFilter(name)) {
            return EMPTY_ENUMERATION;
        }
        return super.getResources(name);
    }
}

