/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ITemplateElement;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ITemplateProjectData;
import org.springsource.ide.eclipse.commons.content.core.ContentItem;

public class Template
implements ITemplateElement {
    private final String name;
    private final String description;
    private final ImageDescriptor icon;
    private ITemplateProjectData data;
    private final ContentItem item;

    public Template(ContentItem item, ImageDescriptor icon) {
        this.item = item;
        this.name = item.getName();
        this.description = item.getDescription();
        this.icon = icon;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public ContentItem getItem() {
        return this.item;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ITemplateProjectData getTemplateData() {
        return this.data;
    }

    public URL getTemplateLocation() throws CoreException {
        if (this.data != null) {
            try {
                return this.data.getJsonDescriptor().toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Unable to resolve template location", (Throwable)e));
            }
        }
        return null;
    }

    public URL getZippedLocation() throws CoreException {
        if (this.data != null) {
            try {
                return this.data.getZippedProject().toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Unable to resolve template zipped location", (Throwable)e));
            }
        }
        return null;
    }

    public void setTemplateData(ITemplateProjectData data) {
        this.data = data;
    }

    public String toString() {
        return String.valueOf(this.getClass().toString()) + "-" + this.name.toString();
    }
}

