/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes.misc;

import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.quickfixes.AbstractASTResolution;
import net.sf.eclipsecs.ui.quickfixes.Messages;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class UncommentedMainQuickfix
extends AbstractASTResolution {
    private static final int JAVADOC_COMMENT_LENGTH = 6;

    @Override
    protected ASTVisitor handleGetCorrectingASTVisitor(final IRegion lineInfo, int markerStartOffset) {
        return new ASTVisitor(){

            public boolean visit(MethodDeclaration node) {
                int pos = node.getStartPosition() + (node.getJavadoc() != null ? node.getJavadoc().getLength() + 6 : 0);
                if (UncommentedMainQuickfix.this.containsPosition(lineInfo, pos) && node.getName().getFullyQualifiedName().equals("main")) {
                    node.delete();
                }
                return true;
            }
        };
    }

    public String getDescription() {
        return Messages.UncommentedMainQuickfix_description;
    }

    public String getLabel() {
        return Messages.UncommentedMainQuickfix_label;
    }

    @Override
    public Image getImage() {
        return CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.CORRECTION_REMOVE);
    }
}

