/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.config;

import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.PropertiesContentAssistProcessor;
import net.sf.eclipsecs.ui.util.SWTUtil;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.contentassist.ContentAssistHandler;

public class ResolvablePropertyEditDialog
extends TitleAreaDialog {
    private Text mTxtName;
    private Text mTxtValue;
    private ResolvableProperty mProperty;

    ResolvablePropertyEditDialog(Shell parent, ResolvableProperty prop) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.mProperty = prop;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.ResolvablePropertyEditDialog_titleMessageArea);
        this.setMessage(Messages.ResolvablePropertyEditDialog_msgEditProperty);
        Composite dialog = new Composite(composite, 0);
        dialog.setLayout((Layout)new GridLayout(2, false));
        dialog.setLayoutData((Object)new GridData(1808));
        Label lblName = new Label(dialog, 0);
        lblName.setText(Messages.ResolvablePropertyEditDialog_lblName);
        this.mTxtName = new Text(dialog, 2052);
        this.mTxtName.setLayoutData((Object)new GridData(768));
        this.mTxtName.setText(this.mProperty.getPropertyName() != null ? this.mProperty.getPropertyName() : "");
        Label lblValue = new Label(dialog, 0);
        lblValue.setText(Messages.ResolvablePropertyEditDialog_lblValue);
        this.mTxtValue = new Text(dialog, 2052);
        this.mTxtValue.setLayoutData((Object)new GridData(768));
        this.mTxtValue.setText(this.mProperty.getValue() != null ? this.mProperty.getValue() : "");
        ContentAssistHandler.createHandlerForText((Text)this.mTxtValue, (SubjectControlContentAssistant)this.createContentAssistant());
        return composite;
    }

    public void create() {
        super.create();
        SWTUtil.addResizeSupport((Dialog)this, CheckstyleUIPlugin.getDefault().getDialogSettings(), ResolvablePropertyEditDialog.class.getName());
    }

    protected void okPressed() {
        if (StringUtils.trimToNull((String)this.mTxtName.getText()) == null) {
            this.setErrorMessage(Messages.ResolvablePropertyEditDialog_msgMissingName);
            return;
        }
        if (StringUtils.trimToNull((String)this.mTxtValue.getText()) == null) {
            this.setErrorMessage(Messages.ResolvablePropertyEditDialog_msgMissingValue);
            return;
        }
        this.mProperty.setPropertyName(this.mTxtName.getText());
        this.mProperty.setValue(this.mTxtValue.getText());
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ResolvablePropertyEditDialog_titleDialog);
    }

    private SubjectControlContentAssistant createContentAssistant() {
        SubjectControlContentAssistant contentAssistant = new SubjectControlContentAssistant();
        contentAssistant.setRestoreCompletionProposalSize(CheckstyleUIPlugin.getDefault().getDialogSettings());
        PropertiesContentAssistProcessor processor = new PropertiesContentAssistProcessor();
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContextInformationPopupOrientation(20);
        contentAssistant.setInformationControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        return contentAssistant;
    }
}

