/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.progress.IProgressConstants;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelContentProvider;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.ILazyInitializedModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class BeansNavigatorContentProvider
extends BeansModelContentProvider
implements ICommonContentProvider {
    private String providerID;

    @Override
    public Object[] getElements(Object inputElement) {
        if ("org.springframework.ide.eclipse.beans.ui.navigator.projectExplorerContent".equals(this.providerID)) {
            return SpringCoreUtils.getSpringProjects().toArray();
        }
        return super.getElements(inputElement);
    }

    @Override
    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ISpringProject) {
            IBeansProject beansProject = BeansCorePlugin.getModel().getProject(((ISpringProject)parentElement).getProject());
            if (!(beansProject == null || beansProject.getConfigs().isEmpty() && beansProject.getConfigSets().isEmpty())) {
                return new Object[]{beansProject};
            }
        } else {
            if (parentElement instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)parentElement).isInitialized()) {
                this.triggerDeferredElementLoading(parentElement, ((IModelElement)parentElement).getElementParent());
                return IModelElement.NO_CHILDREN;
            }
            if (parentElement instanceof IBeansImport) {
                return this.getImportChildren(parentElement);
            }
        }
        return super.getChildren(parentElement);
    }

    protected Object[] getImportChildren(Object parentElement) {
        Set importedBeansConfigs = ((IBeansImport)parentElement).getImportedBeansConfigs();
        LinkedHashSet<Object> importedFiles = new LinkedHashSet<Object>();
        for (IBeansConfig bc : importedBeansConfigs) {
            if (bc.isElementArchived()) {
                importedFiles.add(new ZipEntryStorage((IResourceModelElement)bc));
                continue;
            }
            importedFiles.add(bc.getElementResource());
        }
        return importedFiles.toArray(new Object[importedFiles.size()]);
    }

    @Override
    protected Object[] getConfigSetChildren(IBeansConfigSet configSet) {
        LinkedHashSet<ISourceModelElement> children = new LinkedHashSet<ISourceModelElement>();
        for (IBeansConfig config : configSet.getConfigs()) {
            if (config instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)config).isInitialized()) {
                this.triggerDeferredElementLoading(config, configSet);
                continue;
            }
            this.getConfigChildren(children, config);
        }
        return children.toArray();
    }

    @Override
    protected Object[] getJavaTypeChildren(IType type) {
        if ("org.springframework.ide.eclipse.beans.ui.navigator.springExplorerContent".equals(this.providerID)) {
            return IModelElement.NO_CHILDREN;
        }
        return super.getJavaTypeChildren(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerDeferredElementLoading(Object config, Object parent) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Job[] buildJobs = Job.getJobManager().find(ModelJob.MODEL_CONTENT_FAMILY);
            int i = 0;
            while (i < buildJobs.length) {
                ModelJob job;
                Job curr = buildJobs[i];
                if (curr instanceof ModelJob && (job = (ModelJob)curr).isCoveredBy(config, parent)) {
                    return;
                }
                ++i;
            }
        }
        ModelJob job = new ModelJob(config, parent, this);
        job.setPriority(10);
        job.setProperty(IProgressConstants.ICON_PROPERTY, BeansUIImages.DESC_OBJS_SPRING);
        job.schedule();
    }

    private Object[] superGetChildren(Object parentElement) {
        return super.getChildren(parentElement);
    }

    @Override
    public synchronized void elementChanged(ModelChangeEvent event) {
        IModelElement element = event.getElement();
        if (element instanceof IBeansProject) {
            IProject project = ((IBeansProject)element).getProject();
            if ("org.springframework.ide.eclipse.beans.ui.navigator.projectExplorerContent".equals(this.providerID)) {
                this.refreshViewerForElement(project);
                this.refreshViewerForElement(JdtUtils.getJavaProject((IProject)project));
            } else if ("org.springframework.ide.eclipse.beans.ui.navigator.springExplorerContent".equals(this.providerID)) {
                this.refreshViewerForElement(SpringCore.getModel().getProject(project));
            } else {
                super.elementChanged(event);
            }
        } else if (element instanceof IBeansConfig) {
            IBeansConfig config = (IBeansConfig)element;
            if ("org.springframework.ide.eclipse.beans.ui.navigator.projectExplorerContent".equals(this.providerID)) {
                this.refreshBeanClasses(config);
            }
            this.refreshViewerForElement(config.getElementParent());
        } else {
            super.elementChanged(event);
        }
    }

    protected void refreshBeanClasses(IBeansConfig config) {
        Set classes = config.getBeanClasses();
        for (String clazz : classes) {
            IType type = JdtUtils.getJavaType((IProject)config.getElementResource().getProject(), (String)clazz);
            if (type == null) continue;
            this.refreshViewerForElement(type);
        }
    }

    public void init(ICommonContentExtensionSite config) {
        this.providerID = config.getExtension().getId();
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public String toString() {
        return String.valueOf(this.providerID);
    }

    private static class ModelJob
    extends Job {
        public static final Object MODEL_CONTENT_FAMILY = new Object();
        private final Object config;
        private final Object parent;
        private final BeansNavigatorContentProvider contentProvider;

        public ModelJob(Object config, Object parent, BeansNavigatorContentProvider contentProvider) {
            super("Initializing Spring Project '" + ((IResourceModelElement)config).getElementResource().getFullPath().toString().substring(1) + "'");
            this.config = config;
            this.parent = parent;
            this.contentProvider = contentProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] buildJobs = Job.getJobManager().find(MODEL_CONTENT_FAMILY);
                int i = 0;
                while (i < buildJobs.length) {
                    ModelJob job;
                    Job curr = buildJobs[i];
                    if (curr != this && curr instanceof ModelJob && (job = (ModelJob)curr).isCoveredBy(this)) {
                        curr.cancel();
                    }
                    ++i;
                }
            }
            if (this.config instanceof IBeansProject) {
                IBeansProject bp = (IBeansProject)this.config;
                monitor = new SubProgressMonitor(monitor, bp.getConfigs().size());
                monitor.beginTask("Initializing Spring Project '" + ((IResourceModelElement)this.config).getElementResource().getFullPath().toString() + "'", bp.getConfigs().size());
                for (IBeansConfig beansConfig : bp.getConfigs()) {
                    monitor.setTaskName("Loading '" + beansConfig.getElementName() + "'");
                    beansConfig.getBeans();
                    monitor.worked(1);
                }
            } else {
                monitor.beginTask("Loading '" + ((IResourceModelElement)this.config).getElementResource().getFullPath().toString() + "'", 1);
                this.contentProvider.superGetChildren(this.config);
            }
            SpringUIUtils.getStandardDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ModelJob.this.contentProvider.refreshViewerForElement(ModelJob.this.config);
                    ModelJob.this.contentProvider.refreshViewerForElement(ModelJob.this.parent);
                    if (ModelJob.this.parent instanceof IBeansProject) {
                        ModelJob.this.contentProvider.refreshViewerForElement(SpringCore.getModel().getProject(((IBeansProject)ModelJob.this.parent).getProject()));
                    }
                    if ("org.springframework.ide.eclipse.beans.ui.navigator.projectExplorerContent".equals(ModelJob.this.contentProvider.providerID) && ModelJob.this.config instanceof IResourceModelElement) {
                        ModelJob.this.contentProvider.refreshViewerForElement(((IResourceModelElement)ModelJob.this.config).getElementResource());
                    }
                    BeansModelLabelDecorator.update();
                }
            });
            monitor.worked(1);
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean isCoveredBy(ModelJob other) {
            return other.parent.equals(this.parent) && other.config.equals(this.config);
        }

        public boolean isCoveredBy(Object otherConfig, Object otherParent) {
            return otherParent.equals(this.parent) && otherConfig.equals(this.config);
        }

        public boolean belongsTo(Object family) {
            return MODEL_CONTENT_FAMILY == family;
        }
    }
}

