/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.mylyn.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;
import org.eclipse.wst.xml.ui.internal.contentassist.ProposalComparator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.BeansJavaCompletionProposal;

public class FocusedStructuredTextViewerContentAssistProcessor
implements IContentAssistProcessor {
    private static final int THRESHOLD_INTEREST = 10000;
    private static final int THRESHOLD_IMPLICIT_INTEREST = 20000;
    private static final int RELEVANCE_IMPLICIT_INTEREST = 300;
    private static final String IDENTIFIER_THIS = "this";
    public static final String LABEL_SEPARATOR = " -------------------------------------------- ";
    private final IContentAssistProcessor processor;

    public FocusedStructuredTextViewerContentAssistProcessor(IContentAssistProcessor processor) {
        this.processor = processor;
    }

    private boolean boostRelevanceWithInterest(BeansJavaCompletionProposal proposal, int baseRelevance) {
        boolean hasInteresting = false;
        Object element = proposal.getProposedObject();
        if (element != null) {
            String handle = this.determineHandleForProposedElement(element);
            if (handle != null) {
                hasInteresting = this.determineRelevanceForProposedElements(proposal, baseRelevance, handle);
            }
        } else if (this.isImplicitlyInteresting(proposal)) {
            proposal.setRelevance(20000 + proposal.getRelevance());
            hasInteresting = true;
        }
        return hasInteresting;
    }

    /*
     * WARNING - void declaration
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        void var6_11;
        ICompletionProposal[] rawProposals = this.processor.computeCompletionProposals(viewer, offset);
        ArrayList<Object> proposals = new ArrayList<Object>();
        if (rawProposals != null && rawProposals.length > 0) {
            proposals.addAll(Arrays.asList(rawProposals));
        }
        if (!ContextCorePlugin.getContextManager().isContextActive()) {
            return rawProposals;
        }
        int baseRelevance = 0;
        for (Object e : proposals) {
            if (!(e instanceof IRelevanceCompletionProposal) || ((IRelevanceCompletionProposal)e).getRelevance() <= baseRelevance) continue;
            baseRelevance = ((IRelevanceCompletionProposal)e).getRelevance();
        }
        boolean bl = false;
        boolean hasInterestingProposals = false;
        for (Object e : proposals) {
            if (!(e instanceof BeansJavaCompletionProposal)) continue;
            boolean foundInteresting = this.boostRelevanceWithInterest((BeansJavaCompletionProposal)e, baseRelevance);
            if (!hasInterestingProposals && foundInteresting) {
                hasInterestingProposals = true;
            }
            if (!foundInteresting) continue;
            ++var6_11;
        }
        if (hasInterestingProposals && proposals.size() > var6_11) {
            proposals.add((Object)new FocusedProposalSeparator(baseRelevance));
        }
        ICompletionProposal[] newProposals = proposals.toArray(new ICompletionProposal[proposals.size()]);
        Arrays.sort(newProposals, new ProposalComparator());
        return newProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.processor.computeContextInformation(viewer, offset);
    }

    protected String determineHandleForProposedElement(Object element) {
        if (element != null && element instanceof IJavaElement) {
            return ((IJavaElement)element).getHandleIdentifier();
        }
        return null;
    }

    private boolean determineRelevanceForProposedElements(BeansJavaCompletionProposal proposal, int baseRelevance, String handle) {
        IInteractionElement mylynElement = ContextCorePlugin.getContextManager().getElement(handle);
        if (mylynElement.getInterest().isInteresting()) {
            float interest = mylynElement.getInterest().getValue();
            proposal.setRelevance(10000 + baseRelevance + (int)(interest * 10.0f));
            return true;
        }
        return false;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.processor.getCompletionProposalAutoActivationCharacters();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.processor.getContextInformationAutoActivationCharacters();
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.processor.getContextInformationValidator();
    }

    public String getErrorMessage() {
        return this.processor.getErrorMessage();
    }

    public boolean isImplicitlyInteresting(BeansJavaCompletionProposal proposal) {
        return proposal.getRelevance() > 300 && !IDENTIFIER_THIS.equals(proposal.getDisplayString());
    }

    static class FocusedProposalSeparator
    extends JavaCompletionProposal
    implements IRelevanceCompletionProposal {
        public FocusedProposalSeparator(int baseRelevance) {
            super("", 0, 0, CommonImages.getImage((ImageDescriptor)CommonImages.SEPARATOR_LIST), FocusedStructuredTextViewerContentAssistProcessor.LABEL_SEPARATOR, 10000 + baseRelevance);
        }
    }
}

