/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.classreading;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.io.FileResource;
import org.springframework.ide.eclipse.core.java.classreading.JdtConnectedAnnotationMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.type.asm.CachingClassReaderFactory;

public class JdtConnectedMetadataReader
implements MetadataReader {
    private final IType type;
    private final JdtConnectedAnnotationMetadataReadingVisitor visitor;

    public JdtConnectedMetadataReader(IType type, CachingClassReaderFactory classReaderFactory, ClassLoader classloader) {
        this.type = type;
        this.visitor = new JdtConnectedAnnotationMetadataReadingVisitor(classloader, type);
        try {
            ClassReader classReader = classReaderFactory.getClassReader(type.getFullyQualifiedName());
            classReader.accept((ClassVisitor)this.visitor, 0);
        }
        catch (IOException e) {
            SpringCore.log(e);
        }
    }

    public ClassMetadata getClassMetadata() {
        return this.visitor;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.visitor;
    }

    public Resource getResource() {
        try {
            return new FileResource((IFile)this.type.getUnderlyingResource());
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }
}

