/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.graphics.Image;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.IPropertyProvider;
import org.tigris.subversion.subclipse.ui.compare.PropertyComparePropertyNode;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class PropertyCompareLocalResourceNode
implements IStructureComparator,
ITypedElement,
IStreamContentAccessor,
IPropertyProvider {
    private IResource resource;
    private boolean recursive;
    private ISVNProperty[] properties;
    private Object[] children;

    public PropertyCompareLocalResourceNode(IResource resource, boolean recursive, ISVNProperty[] properties) {
        this.resource = resource;
        this.recursive = recursive;
        this.properties = properties;
    }

    public InputStream getContents() throws CoreException {
        return null;
    }

    public String getName() {
        return this.resource.getName();
    }

    public Image getImage() {
        return CompareUI.getImage((IAdaptable)this.resource);
    }

    public String getType() {
        return "FOLDER";
    }

    public Object[] getChildren() {
        if (this.children == null) {
            ArrayList<Object> childList = new ArrayList<Object>();
            ISVNProperty[] iSVNPropertyArray = this.properties;
            int n = 0;
            int n2 = iSVNPropertyArray.length;
            while (n < n2) {
                ISVNProperty property = iSVNPropertyArray[n];
                if (property.getFile().getAbsolutePath().equals(this.resource.getLocation().toOSString())) {
                    childList.add(new PropertyComparePropertyNode(property));
                }
                ++n;
            }
            if (this.recursive && this.resource instanceof IContainer) {
                try {
                    IResource[] childResources;
                    IResource[] iResourceArray = childResources = ((IContainer)this.resource).members();
                    n2 = 0;
                    int n3 = iResourceArray.length;
                    while (n2 < n3) {
                        IResource childResource = iResourceArray[n2];
                        PropertyCompareLocalResourceNode childNode = new PropertyCompareLocalResourceNode(childResource, true, this.properties);
                        childList.add(childNode);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    SVNUIPlugin.log(e);
                }
            }
            this.children = new Object[childList.size()];
            childList.toArray(this.children);
        }
        return this.children;
    }

    public boolean equals(Object other) {
        if (!this.recursive) {
            return true;
        }
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void getProperties(boolean recursive) {
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = svnResource.getRepository().getSVNClient();
                this.properties = svnClient.getProperties(this.resource.getLocation().toFile(), recursive);
            }
            catch (Exception e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
        }
        finally {
            svnResource.getRepository().returnSVNClient(svnClient);
        }
    }

    public String getLabel() {
        return String.valueOf(Policy.bind("PropertyCompareLocalResourceNode.0")) + this.resource.getName();
    }

    public boolean isEditable() {
        return true;
    }

    public IResource getResource() {
        return this.resource;
    }
}

