/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.EditPropertiesAction;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;

public class FlowSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private Text labelText;
    private ISubflowState state;
    private ISubflowState oldState;
    private Button browseBeanButton;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            ActionRegistry actionRegistry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
            EditPropertiesAction action = (EditPropertiesAction)actionRegistry.getAction((Object)"Edit_propeties");
            action.setOpenDialog(false);
            EditPropertiesCommand command = new EditPropertiesCommand();
            ISubflowState clone = null;
            if (FlowSection.this.state instanceof ICloneableModelElement) {
                clone = (ISubflowState)((ICloneableModelElement)FlowSection.this.state).cloneModelElement();
            }
            clone.setFlow(FlowSection.this.labelText.getText());
            command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)FlowSection.this.state), (IWebflowModelElement)clone);
            if (action != null) {
                FlowSection.this.state.removePropertyChangeListener((PropertyChangeListener)FlowSection.this);
                action.runWithCommand(command);
                FlowSection.this.state.addPropertyChangeListener((PropertyChangeListener)FlowSection.this);
            }
        }
    };

    protected void handleSelectionChanged() {
        ElementListSelectionDialog dialog = DialogUtils.openFlowReferenceDialog();
        if (dialog.open() == 0) {
            this.labelText.setText((String)dialog.getFirstResult());
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.browseBeanButton = this.getWidgetFactory().createButton(composite, "...", 8);
        FormData data = new FormData();
        data.left = new FormAttachment(96, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.browseBeanButton.setLayoutData((Object)data);
        this.browseBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FlowSection.this.handleSelectionChanged();
            }
        });
        this.labelText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        this.labelText.setEditable(false);
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(95, 0);
        data.top = new FormAttachment((Control)this.browseBeanButton, 0, 0x1000000);
        this.labelText.setLayoutData((Object)data);
        this.labelText.addModifyListener(this.listener);
        CLabel comboLabel = this.getWidgetFactory().createCLabel(composite, "Flow:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.labelText, -5);
        data.top = new FormAttachment((Control)this.browseBeanButton, 0, 0x1000000);
        comboLabel.setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (this.oldState != null) {
            this.oldState.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (input instanceof AbstractStatePart && ((AbstractStatePart)input).getModel() instanceof ISubflowState) {
            this.state = (ISubflowState)((AbstractStatePart)input).getModel();
            this.state.addPropertyChangeListener((PropertyChangeListener)this);
            this.oldState = this.state;
        }
    }

    public void refresh() {
        this.labelText.removeModifyListener(this.listener);
        if (this.state != null && this.state.getFlow() != null) {
            this.labelText.setText(this.state.getFlow());
        }
        this.labelText.addModifyListener(this.listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.dispose();
    }
}

