/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;

public class ReconnectIfTransitionTargetCommand
extends Command {
    protected ITransitionableTo oldTarget;
    protected IIf source;
    protected ITransitionableTo target;
    protected IIfTransition transition;

    public boolean canExecute() {
        return !this.transition.getToState().equals(this.target) && this.target instanceof IState;
    }

    public void execute() {
        if (this.target != null) {
            this.transition.setToState(this.target);
        }
    }

    public IIf getSource() {
        return this.source;
    }

    public ITransitionableTo getTarget() {
        return this.target;
    }

    public ITransition getTransition() {
        return this.transition;
    }

    public void setSource(IIf activity) {
        this.source = activity;
    }

    public void setTarget(ITransitionableTo activity) {
        this.target = activity;
    }

    public void setTransition(IIfTransition trans) {
        this.transition = trans;
        this.source = trans.getFromIf();
        this.oldTarget = trans.getToState();
    }

    public void undo() {
        this.transition.setToState(this.oldTarget);
    }
}

