/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.completions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.HoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.util.HtmlBuffer;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;

public class TypeNavigationHoverInfo
extends HoverInfo {
    private final String id;
    private final String propName;
    private Type parentType;
    private Type type;
    private TypeUtil typeUtil;

    public TypeNavigationHoverInfo(String id, String propName, Type fromType, Type toType, TypeUtil typeUtil) {
        this.id = id;
        this.propName = propName;
        this.parentType = fromType;
        this.type = toType;
        this.typeUtil = typeUtil;
    }

    @Override
    public String getHtml() {
        HtmlBuffer html = new HtmlBuffer();
        html.raw("<b>");
        html.text(this.id);
        html.raw("</b>");
        html.raw("<br>");
        String typeStr = this.type.toString();
        if (typeStr == null) {
            typeStr = Object.class.getName();
        }
        html.raw("<a href=\"");
        html.url("type/" + this.type);
        html.raw("\">");
        html.text(typeStr);
        html.raw("</a>");
        String description = this.getDescription();
        if (description != null) {
            html.raw("<br><br>");
            html.raw(description);
        }
        return html.toString();
    }

    private String getDescription() {
        try {
            List<IJavaElement> jes = this.getAllJavaElements();
            if (jes != null) {
                for (IJavaElement je : jes) {
                    String jdoc;
                    if (!(je instanceof IMember) || (jdoc = JavadocContentAccess2.getHTMLContent((IMember)((IMember)je), (boolean)true)) == null) continue;
                    return jdoc;
                }
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    @Override
    public List<IJavaElement> getJavaElements() {
        if (this.propName != null) {
            Type beanType = this.parentType;
            IMethod je = this.typeUtil.getSetter(beanType, this.propName);
            if (je != null) {
                return Collections.singletonList(je);
            }
            je = this.typeUtil.getGetter(beanType, this.propName);
            if (je != null) {
                return Collections.singletonList(je);
            }
            je = this.typeUtil.getField(beanType, this.propName);
            if (je != null) {
                return Collections.singletonList(je);
            }
        }
        return Collections.emptyList();
    }

    private List<IJavaElement> getAllJavaElements() {
        if (this.propName != null) {
            Type beanType = this.parentType;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>(3);
            this.maybeAdd(elements, (IJavaElement)this.typeUtil.getField(beanType, this.propName));
            this.maybeAdd(elements, (IJavaElement)this.typeUtil.getSetter(beanType, this.propName));
            this.maybeAdd(elements, this.typeUtil.getGetter(beanType, this.propName));
            if (!elements.isEmpty()) {
                return elements;
            }
        }
        return Collections.emptyList();
    }

    private void maybeAdd(ArrayList<IJavaElement> elements, IJavaElement e) {
        if (e != null) {
            elements.add(e);
        }
    }
}

