/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.template.infrastructure.SimpleProjectContentManager;
import org.springsource.ide.eclipse.commons.content.core.ContentItem;
import org.springsource.ide.eclipse.commons.core.ZipFileUtil;

public class BundleContentLoader {
    private final Bundle bundle;
    private final ContentItem contentItem;
    private final SimpleProjectContentManager contentManager;

    public BundleContentLoader(ContentItem contentItem, Bundle bundle, SimpleProjectContentManager contentManager) {
        this.contentItem = contentItem;
        this.bundle = bundle;
        this.contentManager = contentManager;
    }

    public void load(IProgressMonitor monitor) throws CoreException {
        block11: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
            try {
                File baseInstallDirectory = this.contentManager.getInstallDirectory();
                if (baseInstallDirectory == null || !baseInstallDirectory.exists()) {
                    throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)"Installation directory for bundled contents in bundle {0} does not exist. Unable to extract contents to local directory.", (Object)WizardPlugin.getDefault().getBundle().getSymbolicName())));
                }
                File directory = new File(baseInstallDirectory, this.contentItem.getPath());
                if (this.contentManager.exists(directory)) {
                    return;
                }
                String url = this.contentItem.getLocalDescriptor().getUrl();
                InputStream bundleResourceInput = null;
                try {
                    URI uri = new URI(url);
                    if (this.bundle != null && uri.getScheme().startsWith("file")) {
                        Path path = new Path(uri.getPath());
                        bundleResourceInput = FileLocator.openStream((Bundle)WizardPlugin.getDefault().getBundle(), (IPath)path, (boolean)false);
                    }
                }
                catch (URISyntaxException e) {
                    String message = NLS.bind((String)"Incorrect URI for resource {0} in bundle {1}. Unable to load template data.", (Object)url, (Object)this.bundle.getLocation());
                    throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", message, (Throwable)e));
                }
                catch (IOException e) {
                    String message = NLS.bind((String)"I/O error. Failed to read resource {0} in bundle {1}. Unable to load template data.", (Object)url, (Object)this.bundle.getLocation());
                    throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", message, (Throwable)e));
                }
                File archiveFile = new File(baseInstallDirectory, String.valueOf(this.contentItem.getPath()) + ".zip");
                if (bundleResourceInput != null) {
                    this.load(bundleResourceInput, archiveFile, directory, monitor);
                    break block11;
                }
                throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Unable to create input stream to descriptor files in bundle: " + WizardPlugin.getDefault().getBundle().getSymbolicName()));
            }
            finally {
                progress.done();
            }
        }
    }

    protected void load(InputStream in, File localArchiveFile, File directory, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        OutputStream out = null;
        try {
            try {
                int read;
                out = new BufferedOutputStream(new FileOutputStream(localArchiveFile));
                byte[] buf = new byte[40960];
                while ((read = in.read(buf)) >= 0) {
                    if (read <= 0) continue;
                    out.write(buf, 0, read);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "I/O error while copying template zip file " + localArchiveFile.getAbsolutePath() + " to " + directory.getAbsolutePath() + " ---- " + e.getMessage(), (Throwable)e));
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "I/O error while copying template zip file " + localArchiveFile.getAbsolutePath() + " to " + directory.getAbsolutePath() + " ---- " + e.getMessage(), (Throwable)e));
            }
        }
        try {
            try {
                URL fileUrl = localArchiveFile.toURI().toURL();
                ZipFileUtil.unzip((URL)fileUrl, (File)directory, (IProgressMonitor)progress.newChild(30));
                if (directory.listFiles().length <= 0) {
                    String message = NLS.bind((String)"Zip file {0} appears to be empty", (Object)localArchiveFile);
                    throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", message));
                }
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Unable to unzip template content due to malformed URL: " + e.getMessage(), (Throwable)e));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "I/O error while unzipping template zip file " + localArchiveFile.getAbsolutePath() + " into " + directory.getAbsolutePath() + " --- " + e.getMessage(), (Throwable)e));
            }
        }
        finally {
            localArchiveFile.delete();
        }
    }
}

