/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ContentManager;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ContentProvider;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GettingStartedGuide;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GithubRepoContent;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ReferenceApp;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ReferenceAppMetaData;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.TutorialGuide;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.GithubClient;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.Repo;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;

public class GettingStartedContent
extends ContentManager {
    private static GettingStartedContent INSTANCE = null;
    private static final boolean ADD_REAL = true;
    private static final boolean ADD_MOCKS = false;
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder") || ("" + Platform.getLocation()).contains("bamboo");
    private final GithubClient github = new GithubClient();
    private Repo[] cachedRepos = null;

    public static GettingStartedContent getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GettingStartedContent(StsProperties.getInstance((IProgressMonitor)new NullProgressMonitor()));
        }
        return INSTANCE;
    }

    private Repo[] getGuidesRepos() {
        if (this.cachedRepos == null) {
            Repo[] repos = this.github.getOrgRepos("spring-guides");
            Arrays.sort(repos, new Comparator<Repo>(){

                @Override
                public int compare(Repo o1, Repo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.cachedRepos = repos;
        }
        return this.cachedRepos;
    }

    private GettingStartedContent(final StsProperties stsProps) {
        this.register(GettingStartedGuide.class, "A guide is a short focussed tutorial on how to use Spring to accomplish a specific task. It has an 'initial' code set, a 'complete' codeset and a readme file explaining how you get from one to the other.", new ContentProvider<GettingStartedGuide>(){

            public GettingStartedGuide[] fetch(DownloadManager downloader) {
                LinkedHashMap<String, GettingStartedGuide> guides = new LinkedHashMap<String, GettingStartedGuide>();
                this.addGuidesFrom(GettingStartedContent.this.getGuidesRepos(), guides, downloader);
                return guides.values().toArray(new GettingStartedGuide[guides.size()]);
            }

            private LinkedHashMap<String, GettingStartedGuide> addGuidesFrom(Repo[] repos, LinkedHashMap<String, GettingStartedGuide> guides, DownloadManager downloader) {
                Repo[] repoArray = repos;
                int n = repos.length;
                int n2 = 0;
                while (n2 < n) {
                    Repo repo = repoArray[n2];
                    String name = repo.getName();
                    if (name.startsWith("gs-") && !guides.containsKey(name)) {
                        guides.put(name, new GettingStartedGuide(stsProps, repo, downloader));
                    }
                    ++n2;
                }
                return guides;
            }
        });
        this.register(ReferenceApp.class, "A reference app is a larger, complete application that shows how to use spring properly in a more realistic context.", new ContentProvider<ReferenceApp>(){

            public ReferenceApp[] fetch(DownloadManager downloader) {
                ReferenceAppMetaData[] infos = GettingStartedContent.this.github.get(stsProps.get("spring.reference.app.discovery.url"), ReferenceAppMetaData[].class, new Object[0]);
                ReferenceApp[] apps = new ReferenceApp[infos.length];
                int i = 0;
                while (i < apps.length) {
                    apps[i] = this.create(downloader, infos[i]);
                    ++i;
                }
                return apps;
            }

            private ReferenceApp create(DownloadManager dl, ReferenceAppMetaData md) {
                return new ReferenceApp(md, dl, GettingStartedContent.this.github);
            }
        });
    }

    public GettingStartedGuide[] getGSGuides() {
        return this.get(GettingStartedGuide.class);
    }

    public TutorialGuide[] getTutorials() {
        return this.get(TutorialGuide.class);
    }

    public ReferenceApp[] getReferenceApps() {
        return this.get(ReferenceApp.class);
    }

    public GithubRepoContent[] getAllGuides() {
        ArrayList<GithubRepoContent> all = new ArrayList<GithubRepoContent>();
        all.addAll(this.asList(this.getTutorials()));
        all.addAll(this.asList(this.getGSGuides()));
        return all.toArray(new GithubRepoContent[all.size()]);
    }

    private <A> Collection<A> asList(A[] tutorials) {
        if (tutorials == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(tutorials);
    }
}

