/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.crucible.api.model;

import com.atlassian.theplugin.commons.cfg.ServerIdImpl;
import com.atlassian.theplugin.commons.crucible.api.model.CustomFilter;
import com.atlassian.theplugin.commons.crucible.api.model.State;
import org.apache.commons.lang.StringUtils;

public class CustomFilterBean
implements CustomFilter {
    private ServerIdImpl serverId;
    private String title = "";
    private State[] state = new State[0];
    private String author = "";
    private String moderator = "";
    private String creator = "";
    private String reviewer = "";
    private boolean orRoles;
    private Boolean complete;
    private Boolean allReviewersComplete;
    private String projectKey = "";
    private boolean enabled;
    private static final double ID_DISCRIMINATOR = 1002.0;
    private static final int HASHCODE_CONSTANT = 31;
    private static final int SHIFT_32 = 32;
    public static final String FILTER_ID = "MANUAL_FILTER_ID";
    private final String filterName = "Custom";
    private boolean empty = false;
    private transient long uid = System.currentTimeMillis() + (long)(Math.random() * 1002.0);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomFilterBean that = (CustomFilterBean)o;
        if (this.uid != that.uid) {
            return false;
        }
        return "Custom".equals(that.filterName);
    }

    public int hashCode() {
        int result = "Custom" != null ? "Custom".hashCode() : 0;
        result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
        return result;
    }

    public ServerIdImpl getServerId() {
        return this.serverId;
    }

    public void setServerId(ServerIdImpl serverId) {
        this.serverId = serverId;
    }

    public CustomFilterBean copy(CustomFilterBean bean) {
        this.serverId = bean.serverId;
        this.title = bean.title;
        this.state = bean.state;
        this.author = bean.author;
        this.moderator = bean.moderator;
        this.creator = bean.creator;
        this.reviewer = bean.reviewer;
        this.orRoles = bean.orRoles;
        this.complete = bean.complete;
        this.allReviewersComplete = bean.allReviewersComplete;
        this.projectKey = bean.projectKey;
        this.enabled = bean.enabled;
        this.empty = bean.empty;
        return this;
    }

    public CustomFilterBean(CustomFilterBean bean) {
        this.copy(bean);
    }

    public CustomFilterBean() {
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public State[] getState() {
        return this.state;
    }

    public void setState(State[] state) {
        this.state = state;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getModerator() {
        return this.moderator;
    }

    public void setModerator(String moderator) {
        this.moderator = moderator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getReviewer() {
        return this.reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Boolean isComplete() {
        return this.complete;
    }

    public void setComplete(Boolean complete) {
        this.complete = complete;
    }

    public Boolean isAllReviewersComplete() {
        return this.allReviewersComplete;
    }

    public void setAllReviewersComplete(Boolean allReviewersComplete) {
        this.allReviewersComplete = allReviewersComplete;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public boolean isOrRoles() {
        return this.orRoles;
    }

    public void setOrRoles(boolean orRoles) {
        this.orRoles = orRoles;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getId() {
        return FILTER_ID;
    }

    public String getFilterName() {
        return "Custom";
    }

    public String getFilterUrl() {
        return this.prepareCustomFilterUrl();
    }

    private String prepareCustomFilterUrl() {
        String urlString;
        StringBuilder url = new StringBuilder();
        this.addQueryParam("author", this.getAuthor(), url);
        this.addQueryParam("creator", this.getCreator(), url);
        this.addQueryParam("moderator", this.getModerator(), url);
        this.addQueryParam("reviewer", this.getReviewer(), url);
        this.addQueryParam("project", this.getProjectKey(), url);
        String stateParam = this.getStates();
        this.addQueryParam("states", stateParam, url);
        if (this.isComplete() != null) {
            this.addQueryParam("complete", Boolean.toString(this.isComplete()), url);
        }
        this.addQueryParam("orRoles", Boolean.toString(this.isOrRoles()), url);
        if (this.isAllReviewersComplete() != null) {
            this.addQueryParam("allReviewersComplete", Boolean.toString(this.isAllReviewersComplete()), url);
        }
        return (urlString = url.toString()).equals("?") ? "" : urlString;
    }

    private void addQueryParam(String name, String value, StringBuilder builder) {
        if (!StringUtils.isEmpty((String)value)) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            builder.append(name).append("=").append(value);
        }
    }

    public String getStates() {
        String stateParam = "";
        if (this.getState() != null) {
            State[] stateArray = this.getState();
            int n = stateArray.length;
            int n2 = 0;
            while (n2 < n) {
                State s = stateArray[n2];
                if (stateParam.length() > 0) {
                    stateParam = String.valueOf(stateParam) + ",";
                }
                stateParam = String.valueOf(stateParam) + s.value();
                ++n2;
            }
        }
        return stateParam;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }
}

