/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.quickfixes;

import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.quickfixes.CheckstyleMarkerResolutionGenerator;
import net.sf.eclipsecs.ui.quickfixes.ICheckstyleMarkerResolution;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class FixCheckstyleMarkersJob
extends UIJob {
    private IFile mFile;

    public FixCheckstyleMarkersJob(IFile file) {
        super(Messages.FixCheckstyleMarkersJob_title);
        this.mFile = file;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        try {
            CheckstyleMarkerResolutionGenerator generator = new CheckstyleMarkerResolutionGenerator();
            IMarker[] markers = this.mFile.findMarkers("net.sf.eclipsecs.core.CheckstyleMarker", true, 2);
            int i = 0;
            int size = markers.length;
            while (i < size) {
                int j = 0;
                ICheckstyleMarkerResolution[] resolutions = (ICheckstyleMarkerResolution[])generator.getResolutions(markers[i]);
                int size2 = resolutions.length;
                if (j < size2) {
                    resolutions[j].run(markers[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            return new Status(4, "net.sf.eclipsecs.ui", 0, e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

