/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.resources.BeansResourceChangeListener;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.BeansTypeHierachyState;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.BeansValidationContext;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.java.TypeStructureState;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidator;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationElementLifecycleManager;
import org.springframework.ide.eclipse.core.model.validation.IValidationElementLifecycleManagerExtension;

public class BeansConfigValidator
extends AbstractValidator {
    private Set<String> affectedBeans = new LinkedHashSet<String>();

    public Set<IResource> deriveResources(Object object) {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        if (object instanceof ISpringProject) {
            object = BeansCorePlugin.getModel().getProject(((ISpringProject)object).getProject());
        } else if (object instanceof IFile) {
            object = BeansCorePlugin.getModel().getConfig((IFile)object);
        }
        if (object instanceof IBeansModelElement) {
            if (object instanceof IBeansProject) {
                for (IBeansConfig config : ((IBeansProject)object).getConfigs()) {
                    resources.add(config.getElementResource());
                }
            } else if (object instanceof IBeansConfigSet) {
                for (IBeansConfig config : ((IBeansConfigSet)object).getConfigs()) {
                    resources.add(config.getElementResource());
                }
            } else if (object instanceof IResourceModelElement) {
                resources.add(((IResourceModelElement)object).getElementResource());
            }
        }
        return resources;
    }

    public void cleanup(IResource resource, IProgressMonitor monitor) throws CoreException {
        MarkerUtils.deleteAllMarkers((IResource)resource, (String)this.getMarkerId());
    }

    public Set<IResource> getAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        if (resource instanceof IFile) {
            Set<IBeansConfig> configs = BeansCorePlugin.getModel().getConfigs((IFile)resource, true);
            if (configs != null && configs.size() > 0) {
                for (IBeansConfig beansConfig : configs) {
                    if (beansConfig instanceof IImportedBeansConfig) {
                        IBeansConfig importingConfig = BeansModelUtils.getParentOfClass(beansConfig, IBeansConfig.class);
                        if (importingConfig == null) continue;
                        resources.add(importingConfig.getElementResource());
                        this.addBeans(importingConfig);
                        continue;
                    }
                    resources.add(resource);
                    this.addBeans(beansConfig);
                }
                this.propagateChangedResourceToConfigSets(resources);
            } else if (BeansResourceChangeListener.requiresRefresh((IFile)resource)) {
                this.propagateChangedResourceToProject(resource, resources);
            } else if (kind != 6) {
                TypeStructureState structureState = (TypeStructureState)this.getProjectContributorState().get(TypeStructureState.class);
                BeansTypeHierachyState hierachyState = (BeansTypeHierachyState)this.getProjectContributorState().get(BeansTypeHierachyState.class);
                if (structureState == null || structureState.hasStructuralChanges(resource, 56)) {
                    if (deltaKind == 2 && resource.getName().endsWith(".java")) {
                        this.propagateChangedResourceToProject(resource, resources);
                    } else {
                        for (IBean bean : hierachyState.getBeansByContainingTypes(resource)) {
                            IBeansConfig beansConfig = BeansModelUtils.getConfig(bean);
                            if (beansConfig instanceof IImportedBeansConfig) {
                                IBeansConfig importingConfig = BeansModelUtils.getParentOfClass(beansConfig, IBeansConfig.class);
                                if (importingConfig != null) {
                                    resources.add(importingConfig.getElementResource());
                                    this.affectedBeans.add(bean.getElementID());
                                }
                            } else {
                                resources.add(beansConfig.getElementResource());
                                this.affectedBeans.add(bean.getElementID());
                            }
                            if (!this.isConfigurationBean(bean)) continue;
                            this.addBeans(beansConfig);
                        }
                    }
                }
            }
        }
        return resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConfigurationBean(IBean bean) {
        IType beanType = BeansModelUtils.resolveBeanType(bean);
        if (beanType == null) return false;
        try {
            IAnnotation[] iAnnotationArray = beanType.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if ("Configuration".equals(annotation.getElementName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private void propagateChangedResourceToProject(IResource resource, Set<IResource> resources) {
        IBeansProject beansProject = BeansCorePlugin.getModel().getProject(resource.getProject());
        if (beansProject != null) {
            for (IBeansConfig beansConfig : beansProject.getConfigs()) {
                resources.add(beansConfig.getElementResource());
                this.addBeans(beansConfig);
            }
        }
    }

    private void propagateChangedResourceToConfigSets(Set<IResource> resources) {
        for (IResource resource : new HashSet<IResource>(resources)) {
            IBeansConfig beansConfig = BeansCorePlugin.getModel().getConfig((IFile)resource);
            for (IBeansConfigSet beansConfigSet : BeansModelUtils.getConfigSets(beansConfig)) {
                for (IBeansConfig bc : beansConfigSet.getConfigs()) {
                    if (resources.contains(bc.getElementResource())) continue;
                    resources.add(bc.getElementResource());
                    this.addBeans(bc);
                }
            }
            for (IBeansProject beansProject : BeansCorePlugin.getModel().getProjects()) {
                for (IBeansConfig bc : beansProject.getConfigs()) {
                    for (IBeansImport beansImport : bc.getImports()) {
                        for (IImportedBeansConfig importedBeansConfig : beansImport.getImportedBeansConfigs()) {
                            if (!resource.equals((Object)importedBeansConfig.getElementResource()) || resources.contains(bc.getElementResource())) continue;
                            resources.add(bc.getElementResource());
                            this.addBeans(bc);
                        }
                    }
                }
            }
        }
    }

    protected IValidationContext createContext(IResourceModelElement rootElement, IResourceModelElement contextElement) {
        if (rootElement instanceof IBeansConfig) {
            return new BeansValidationContext((IBeansConfig)rootElement, contextElement);
        }
        return null;
    }

    protected boolean supports(IModelElement element) {
        if (element instanceof IBean) {
            if (this.affectedBeans.contains(element.getElementID())) {
                return true;
            }
            if (((IBean)element).isInnerBean()) {
                return this.supports(BeansModelUtils.getParentOfClass(element, IBean.class));
            }
        } else if (element instanceof IBeansModelElement || element instanceof IBeansImport) {
            return true;
        }
        return false;
    }

    protected boolean shouldValidate(IModelElement element, IValidationContext validationContext) {
        IResourceModelElement contextElement = validationContext.getContextElement();
        return !BeansModelUtils.isProfileDisabled(contextElement, element);
    }

    private void addBeans(IBeansConfig beansConfig) {
        for (IBean bean : BeansModelUtils.getBeans(beansConfig)) {
            this.affectedBeans.add(bean.getElementID());
        }
    }

    protected IValidationElementLifecycleManager createValidationElementLifecycleManager() {
        return new BeanElementLifecycleManager();
    }

    private static class BeanElementLifecycleManager
    implements IValidationElementLifecycleManagerExtension {
        private IBeansConfig rootElement = null;
        private int kind = -1;

        private BeanElementLifecycleManager() {
        }

        public void destroy() {
        }

        public Set<IResourceModelElement> getContextElements() {
            LinkedHashSet<IResourceModelElement> contextElements = new LinkedHashSet<IResourceModelElement>();
            contextElements.addAll(BeansModelUtils.getConfigSets(this.rootElement));
            if (contextElements.isEmpty()) {
                contextElements.add(this.rootElement);
            }
            return contextElements;
        }

        public IResourceModelElement getRootElement() {
            return this.rootElement;
        }

        public void init(IResource resource) {
            if (resource instanceof IFile) {
                this.rootElement = BeansCorePlugin.getModel().getConfig((IFile)resource);
            }
        }

        public void setKind(int kind) {
            this.kind = kind;
        }
    }
}

