/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import java.beans.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicFieldEditorFactory;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicWizardMessages;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizardPage;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.LayoutUtil;

public class NewContentWizardPage
extends NewIonicWidgetWizardPage {
    public NewContentWizardPage() {
        super("newContent", IonicWizardMessages.newContentWizardTitle);
        this.setDescription(IonicWizardMessages.newContentWizardDescription);
    }

    protected void createFieldPanel(Composite parent) {
        IFieldEditor delegate = IonicFieldEditorFactory.createDelegateHandleEditor();
        this.addEditor(delegate, parent);
        this.createIDEditor(parent, true);
        this.addID.setValue((Object)Boolean.FALSE);
        this.createSeparator(parent);
        IFieldEditor padding = IonicFieldEditorFactory.createPaddingEditor();
        this.addEditor(padding, parent);
        this.createSeparator(parent);
        LayoutUtil.TwoColumns columns = NewContentWizardPage.createTwoColumns((Composite)parent);
        IFieldEditor scroll = IonicFieldEditorFactory.createScrollEditor();
        this.addEditor(scroll, columns.left());
        IFieldEditor overflowScroll = IonicFieldEditorFactory.createOverflowScrollEditor();
        this.addEditor(overflowScroll, columns.right());
        IFieldEditor direction = IonicFieldEditorFactory.createDirectionEditor();
        this.addEditor(direction, columns.left());
        IFieldEditor starty = IonicFieldEditorFactory.createStartYEditor();
        this.addEditor(starty, columns.right());
        IFieldEditor scrollbarx = IonicFieldEditorFactory.createScrollbarXEditor();
        this.addEditor(scrollbarx, columns.left());
        IFieldEditor scrollbary = IonicFieldEditorFactory.createScrollbarYEditor();
        this.addEditor(scrollbary, columns.right());
        this.createSeparator(parent);
        IFieldEditor onscroll = IonicFieldEditorFactory.createOnScrollEditor();
        this.addEditor(onscroll, parent);
        IFieldEditor onscrollcomplete = IonicFieldEditorFactory.createOnScrollCompleteEditor();
        this.addEditor(onscrollcomplete, parent);
        this.updateScrollEnablement();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("scroll".equals(name) || "direction".equals(name) || "overflow-scroll".equals(name)) {
            this.updateScrollEnablement();
        }
        super.propertyChange(evt);
    }

    void updateScrollEnablement() {
        boolean scrollEnabled = this.isTrue("scroll");
        boolean ionicScrollEnabled = scrollEnabled && !this.isTrue("overflow-scroll");
        String direction = this.getEditorValue("direction");
        boolean xEnabled = direction.indexOf("x") >= 0;
        boolean yEnabled = direction.indexOf("y") >= 0 || direction.length() == 0;
        this.setEnabled("direction", ionicScrollEnabled);
        this.setEnabled("overflow-scroll", scrollEnabled);
        this.setEnabled("scrollbar-x", ionicScrollEnabled && xEnabled);
        this.setEnabled("scrollbar-y", ionicScrollEnabled && yEnabled);
        this.setEnabled("start-y", ionicScrollEnabled);
        this.setEnabled("on-scroll", scrollEnabled);
        this.setEnabled("on-scroll-complete", scrollEnabled);
    }
}

