/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AbstractJavaElementReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdviceDeclareParentAopSourceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.AdvisedDeclareParentAopReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.BeanMethodReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.BeanReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.IRevealableReferenceNode;
import org.springframework.ide.eclipse.aop.ui.navigator.model.MethodReference;
import org.springframework.ide.eclipse.aop.ui.navigator.util.AopReferenceModelNavigatorUtils;

public class BeanClassTargetReferenceNode
extends AbstractJavaElementReferenceNode
implements IReferenceNode,
IRevealableReferenceNode {
    protected BeanReferenceNode parent;

    public BeanClassTargetReferenceNode(IMember member, BeanReferenceNode parent) {
        super(member);
        this.parent = parent;
    }

    @Override
    public IReferenceNode[] getChildren() {
        MethodReference r;
        ArrayList<Object> nodes = new ArrayList<Object>();
        HashMap<IMember, MethodReference> refs = new HashMap<IMember, MethodReference>();
        for (IAopReference iAopReference : this.parent.getAspectReferences()) {
            if (refs.containsKey(iAopReference.getSource())) {
                ((MethodReference)refs.get(iAopReference.getSource())).getAspects().add(iAopReference);
                continue;
            }
            r = new MethodReference();
            r.setMember(iAopReference.getSource());
            r.getAspects().add(iAopReference);
            refs.put(iAopReference.getSource(), r);
        }
        for (IAopReference iAopReference : this.parent.getAdviseReferences()) {
            if (refs.containsKey(iAopReference.getTarget())) {
                ((MethodReference)refs.get(iAopReference.getTarget())).getAdvices().add(iAopReference);
                continue;
            }
            r = new MethodReference();
            r.setMember(iAopReference.getTarget());
            r.getAdvices().add(iAopReference);
            refs.put(iAopReference.getTarget(), r);
        }
        for (Map.Entry entry : refs.entrySet()) {
            nodes.add(new BeanMethodReferenceNode((IMember)entry.getKey(), ((MethodReference)entry.getValue()).getAspects(), ((MethodReference)entry.getValue()).getAdvices()));
        }
        HashMap hashMap = new HashMap();
        for (IAopReference iAopReference : this.parent.getDeclareParentReferences()) {
            if (hashMap.containsKey(iAopReference.getDefinition())) {
                ((List)hashMap.get(iAopReference.getDefinition())).add(iAopReference);
                continue;
            }
            ArrayList<IAopReference> ref = new ArrayList<IAopReference>();
            ref.add(iAopReference);
            hashMap.put(iAopReference.getDefinition(), ref);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            nodes.add(new AdviceDeclareParentAopSourceNode((List)entry.getValue()));
        }
        if (this.parent.getDeclaredOnReferences().size() > 0) {
            nodes.add(new AdvisedDeclareParentAopReferenceNode(this.parent.getDeclaredOnReferences()));
        }
        return nodes.toArray(new IReferenceNode[nodes.size()]);
    }

    @Override
    public String getText() {
        if (this.element instanceof IType) {
            return String.valueOf(AopReferenceModelNavigatorUtils.JAVA_LABEL_PROVIDER.getText((Object)this.element)) + " - " + AopReferenceModelUtils.getPackageLinkName((IJavaElement)this.element);
        }
        return "<source type not found>";
    }

    @Override
    public boolean hasChildren() {
        return this.parent.getAdviseReferences().size() > 0 || this.parent.getAspectReferences().size() > 0;
    }
}

