/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.web.rss;

import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueCollector;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraInvalidResponseTypeException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraRedirectException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraRemoteMessageException;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.JiraWebSessionCallback;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.rss.JiraRssReader;
import com.atlassian.connector.eclipse.internal.jira.core.service.web.rss.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.WebUtil;

public abstract class JiraRssSessionCallback
extends JiraWebSessionCallback {
    private static final int MAX_REDIRECTS = 3;
    private final boolean useCompression;
    private final IssueCollector collector;

    public JiraRssSessionCallback(boolean useCompression, IssueCollector collector) {
        this.useCompression = useCompression;
        this.collector = collector;
    }

    public final void run(JiraClient client, String baseUrl, IProgressMonitor monitor) throws JiraException, IOException {
        String rssUrl = this.getRssUrl(baseUrl);
        int i = 0;
        while (i <= 3) {
            block12: {
                GetMethod rssRequest = new GetMethod(rssUrl);
                rssRequest.setFollowRedirects(false);
                if (this.useCompression) {
                    rssRequest.setRequestHeader("Accept-Encoding", "gzip");
                }
                try {
                    int code = this.execute((HttpMethod)rssRequest);
                    if (code == 302) {
                        Header locationHeader = rssRequest.getResponseHeader("location");
                        if (locationHeader == null) {
                            throw new JiraRedirectException();
                        }
                        String url = locationHeader.getValue();
                        if (!(url.startsWith(String.valueOf(baseUrl) + "/browse/") || url.startsWith(String.valueOf(baseUrl) + "/si/jira.issueviews:issue-xml/") || url.startsWith(String.valueOf(baseUrl) + "/sr/jira.issueviews:searchrequest-xml/"))) {
                            throw new JiraRedirectException(url);
                        }
                        rssUrl = url;
                        if (!url.startsWith(String.valueOf(baseUrl) + "/sr/jira.issueviews:searchrequest-xml/")) {
                            rssUrl = String.valueOf(rssUrl) + "?decorator=none&view=rss";
                        }
                        break block12;
                    }
                    if (code != 200) {
                        StringBuilder sb = new StringBuilder("Unexpected result code ");
                        sb.append(code);
                        sb.append(" while running query: ");
                        sb.append(rssUrl);
                        throw new JiraRemoteMessageException(sb.toString(), rssRequest.getResponseBodyAsString());
                    }
                    if (!this.isXMLOrRSS((HttpMethod)rssRequest)) {
                        throw new JiraInvalidResponseTypeException(Messages.JiraRssSessionCallback_Repository_returned_invalid_type);
                    }
                    this.parseResult(client, baseUrl, rssRequest, monitor);
                    return;
                }
                finally {
                    rssRequest.releaseConnection();
                }
            }
            ++i;
        }
        throw new JiraException("Maximum number of query redirects exceeded: " + rssUrl);
    }

    private void parseResult(JiraClient client, String baseUrl, GetMethod method, IProgressMonitor monitor) throws IOException, JiraException {
        InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
        try {
            if (this.isResponseGZipped((HttpMethod)method)) {
                in = new GZIPInputStream(in);
            }
            new JiraRssReader(client, this.collector).readRssFeed(in, baseUrl, monitor);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    protected abstract String getRssUrl(String var1) throws JiraException;

    private boolean isResponseGZipped(HttpMethod method) {
        Header contentEncoding = method.getResponseHeader("Content-Encoding");
        return contentEncoding != null && "gzip".equals(contentEncoding.getValue());
    }

    private boolean isXMLOrRSS(HttpMethod method) throws HttpException {
        HeaderElement[] values;
        Header contentType = method.getResponseHeader("Content-Type");
        if (contentType == null) {
            return false;
        }
        HeaderElement[] headerElementArray = values = contentType.getElements();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            HeaderElement element = headerElementArray[n2];
            if (element.getName().startsWith("text/xml")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        try {
            return "RSS[" + super.toString() + " rssUrl=" + this.getRssUrl("") + "]";
        }
        catch (JiraException ex) {
            return "RSS[" + super.toString() + " rssUrl=(exception thrown" + ex.getMessage() + ")]";
        }
    }
}

