/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.model.filter;

import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ComponentFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.EstimateVsActualFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDataExtractor;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueTypeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.JiraFieldSpecialValue;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ProjectFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ResolutionFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.VersionFilter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicFilterDataExtractor
extends FilterDataExtractor {
    @Override
    public Collection<String> extractAssignedTo(UserFilter userFilter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Collection<String> extractComponents(ComponentFilter componentFilter) {
        ArrayList<String> componentIds = new ArrayList<String>();
        if (componentFilter != null) {
            if (componentFilter.hasNoComponent()) {
                componentIds.add(JiraFieldSpecialValue.COMPONENT_NONE.getClassic());
            }
            if (componentFilter.getComponents() != null) {
                componentIds.addAll(this.getComponentIds(Arrays.asList(componentFilter.getComponents())));
            }
        }
        return componentIds;
    }

    @Override
    public Collection<String> extractDates(DateFilter dateFilter, DateFormat dateFormat) {
        return null;
    }

    @Override
    public Collection<String> extractIssueTypes(IssueTypeFilter issueTypeFilter) {
        ArrayList<String> issueTypeNames = new ArrayList<String>();
        if (issueTypeFilter != null && issueTypeFilter.getIsueTypes() != null) {
            issueTypeNames.addAll(this.getIssueTypeIds(Arrays.asList(issueTypeFilter.getIsueTypes())));
        }
        return issueTypeNames;
    }

    @Override
    public Collection<String> extractProjects(ProjectFilter projectFilter) {
        if (projectFilter != null && projectFilter.getProjects() != null) {
            return this.getProjectIds(Arrays.asList(projectFilter.getProjects()));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<String> extractReportedBy(UserFilter userFilter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Collection<String> extractResolutions(ResolutionFilter resolutionFilter) {
        ArrayList<String> resolutionIds = new ArrayList<String>();
        if (resolutionFilter != null) {
            if (resolutionFilter.isUnresolved()) {
                resolutionIds.add(JiraFieldSpecialValue.UNRESOLVED.getClassic());
            }
            if (resolutionFilter.getResolutions() != null) {
                resolutionIds.addAll(this.getResolutionIds(Arrays.asList(resolutionFilter.getResolutions())));
            }
        }
        return resolutionIds;
    }

    @Override
    public Collection<String> extractVersions(VersionFilter filter) {
        ArrayList<String> fixVersionIds = new ArrayList<String>();
        if (filter != null) {
            if (filter.hasNoVersion()) {
                fixVersionIds.add(JiraFieldSpecialValue.VERSION_NONE.getClassic());
            }
            if (filter.isReleasedVersions()) {
                fixVersionIds.add(JiraFieldSpecialValue.VERSION_RELEASED.getClassic());
            }
            if (filter.isUnreleasedVersions()) {
                fixVersionIds.add(JiraFieldSpecialValue.VERSION_UNRELEASED.getClassic());
            }
            if (filter.getVersions() != null) {
                fixVersionIds.addAll(this.getVersionIds(Arrays.asList(filter.getVersions())));
            }
        }
        return fixVersionIds;
    }

    @Override
    public Collection<String> extractWorkRatios(EstimateVsActualFilter estimateFilter) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

