/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.ui.SpringUIMessages;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;

public class AddRemoveNature
implements IObjectActionDelegate {
    public static final String OLD_NATURE_ID1 = "org.springframework.eclipse.core.springnature";
    public static final String OLD_NATURE_ID2 = "org.springframework.ide.eclipse.beans.core.beansnature";
    private List<IProject> selected = new ArrayList<IProject>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selected.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof IJavaProject) {
                    obj = ((IJavaProject)obj).getProject();
                }
                if (obj instanceof IProject) {
                    IProject project = (IProject)obj;
                    if (!project.isOpen()) {
                        enabled = false;
                        break;
                    }
                    this.selected.add(project);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        }
    }

    public void run(IAction action) {
        for (IProject project : this.selected) {
            NullProgressMonitor pm;
            if (SpringCoreUtils.isSpringProject((IResource)project)) {
                pm = new NullProgressMonitor();
                try {
                    SpringCoreUtils.removeProjectNature((IProject)project, (String)OLD_NATURE_ID1, (IProgressMonitor)pm);
                    SpringCoreUtils.removeProjectNature((IProject)project, (String)OLD_NATURE_ID2, (IProgressMonitor)pm);
                    SpringCoreUtils.removeProjectNature((IProject)project, (String)"org.springframework.ide.eclipse.core.springnature", (IProgressMonitor)pm);
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)SpringUIPlugin.getActiveWorkbenchShell(), (String)SpringUIMessages.ProjectNature_errorMessage, (String)NLS.bind((String)SpringUIMessages.ProjectNature_removeError, (Object)project.getName(), (Object)e.getLocalizedMessage()));
                }
                continue;
            }
            pm = new NullProgressMonitor();
            try {
                SpringCoreUtils.removeProjectNature((IProject)project, (String)OLD_NATURE_ID1, (IProgressMonitor)pm);
                SpringCoreUtils.removeProjectNature((IProject)project, (String)OLD_NATURE_ID2, (IProgressMonitor)pm);
                SpringCoreUtils.addProjectNature((IProject)project, (String)"org.springframework.ide.eclipse.core.springnature", (IProgressMonitor)pm);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)SpringUIPlugin.getActiveWorkbenchShell(), (String)SpringUIMessages.ProjectNature_errorMessage, (String)NLS.bind((String)SpringUIMessages.ProjectNature_addError, (Object)project.getName(), (Object)e.getLocalizedMessage()));
            }
        }
    }
}

