/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import name.herlin.command.CommandException;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.eclipse.runtime.cmd.DetectCutAndPasteCmd;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.ui.dialogs.CPDCheckDialog;
import net.sourceforge.pmd.eclipse.ui.views.cpd2.CPDView2;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class CPDCheckProjectAction
extends AbstractUIAction {
    private static final Logger log = Logger.getLogger(CPDCheckProjectAction.class);
    private static final String XML_KEY = "XML";
    private static final String SIMPLE_KEY = "Simple Text";
    private static final String CSV_KEY = "CSV";

    public void run(IAction action) {
        String[] formats;
        String[] languages;
        IWorkbenchPartSite site = this.targetPartSite();
        ISelection sel = site.getSelectionProvider().getSelection();
        Shell shell = site.getShell();
        CPDCheckDialog dialog = new CPDCheckDialog(shell, languages = LanguageFactory.supportedLanguages, formats = new String[]{SIMPLE_KEY, XML_KEY, CSV_KEY});
        if (dialog.open() == 0 && sel instanceof IStructuredSelection) {
            StructuredSelection ss = (StructuredSelection)sel;
            for (Object obj : ss) {
                if (obj instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)obj;
                    IProject project = (IProject)adaptable.getAdapter(IProject.class);
                    if (project == null) {
                        log.warn((Object)"The selected object cannot adapt to a project");
                        log.debug((Object)("   -> selected object : " + obj));
                        continue;
                    }
                    this.detectCutAndPaste(project, dialog);
                    continue;
                }
                log.warn((Object)"The selected object is not adaptable");
                log.debug((Object)("   -> selected object : " + obj));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void detectCutAndPaste(IProject project, CPDCheckDialog dialog) {
        String selectedLanguage = dialog.getSelectedLanguage();
        int tilesize = dialog.getTileSize();
        boolean createReport = dialog.isCreateReportSelected();
        Renderer selectedRenderer = this.createRenderer(dialog.getSelectedFormat());
        String fileName = this.createFileName(dialog.getSelectedFormat());
        CPDView2 view = this.showView();
        try {
            DetectCutAndPasteCmd detectCmd = new DetectCutAndPasteCmd();
            detectCmd.setProject(project);
            detectCmd.setCreateReport(createReport);
            detectCmd.setLanguage(selectedLanguage);
            detectCmd.setMinTileSize(tilesize);
            detectCmd.setRenderer(selectedRenderer);
            detectCmd.setReportName(fileName);
            detectCmd.setUserInitiated(true);
            detectCmd.addPropertyListener(view);
            detectCmd.performExecute();
        }
        catch (CommandException e) {
            this.logError(this.getString("message.error.pmd_exception"), e);
        }
    }

    private CPDView2 showView() {
        CPDView2 view = null;
        try {
            IWorkbenchPage workbenchPage = this.targetPartSite().getPage();
            view = (CPDView2)workbenchPage.showView("net.sourceforge.pmd.eclipse.ui.views.br.CPDView2");
        }
        catch (PartInitException pie) {
            this.logError(this.getString("message.error.view_exception"), pie);
        }
        return view;
    }

    private Renderer createRenderer(String rendererKey) {
        XMLRenderer renderer = null;
        if (XML_KEY.equals(rendererKey)) {
            renderer = new XMLRenderer();
        } else if (SIMPLE_KEY.equals(rendererKey)) {
            renderer = new SimpleRenderer();
        } else if (CSV_KEY.equals(rendererKey)) {
            renderer = new CSVRenderer();
        }
        return renderer;
    }

    private String createFileName(String rendererKey) {
        String fileName = null;
        fileName = XML_KEY.equals(rendererKey) ? "cpd-report.xml" : (CSV_KEY.equals(rendererKey) ? "cpd-report.csv" : "cpd-report.txt");
        return fileName;
    }
}

