/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorDefinition;
import org.springframework.ide.eclipse.beans.core.model.locate.BeansConfigLocatorFactory;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.ui.SpringUIMessages;

public class ConfigLocatorTab {
    private List<BeansConfigLocatorDefinition> beansConfigLocatorDefinitions;
    private CheckboxTableViewer builderViewer;
    private Text descriptionText;
    private IProject project;
    private Color grayColor = new Color((Device)Display.getDefault(), 150, 150, 150);

    public ConfigLocatorTab(IProject project) {
        this.beansConfigLocatorDefinitions = BeansConfigLocatorFactory.getBeansConfigLocatorDefinitions();
        this.project = project;
    }

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (!BeansCorePlugin.getDefault().isAutoDetectionEnabled()) {
            Label warning = new Label(composite, 64);
            warning.setText("Warning: Autodetection has been globally disabled. Editing these setting will have no effect!");
            warning.setForeground(warning.getDisplay().getSystemColor(3));
        }
        Label beansLabel = new Label(composite, 0);
        beansLabel.setText(BeansUIPlugin.getResourceString("ConfigurationPropertyPage.tabConfigLocators.description"));
        this.builderViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.builderViewer.getTable().setLayoutData((Object)gd);
        this.builderViewer.setContentProvider((IContentProvider)new BeansConfigLocatorDefinitionContentProvider(this.beansConfigLocatorDefinitions));
        this.builderViewer.setLabelProvider((IBaseLabelProvider)new BeansConfigLocatorLabelProvider());
        this.builderViewer.setInput((Object)this);
        this.builderViewer.setCheckedElements(this.getEnabledBeansConfigLocatorDefinitions().toArray());
        this.builderViewer.setGrayedElements(this.getGreyedBeansConfigLocatorDefinitions().toArray());
        this.builderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    BeansConfigLocatorDefinition definition = (BeansConfigLocatorDefinition)sel.getFirstElement();
                    if (definition == null) {
                        ConfigLocatorTab.this.clearDescription();
                    } else {
                        ConfigLocatorTab.this.showDescription(definition);
                    }
                }
            }
        });
        this.builderViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                BeansConfigLocatorDefinition obj = (BeansConfigLocatorDefinition)event.getElement();
                if (!obj.getBeansConfigLocator().supports(ConfigLocatorTab.this.project) && event.getChecked()) {
                    ConfigLocatorTab.this.builderViewer.setChecked((Object)obj, false);
                }
            }
        });
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(SpringUIMessages.ProjectBuilderPropertyPage_builderDescription);
        this.descriptionText = new Text(composite, 2378);
        GridData data = new GridData(1808);
        data.heightHint = 30;
        this.descriptionText.setLayoutData((Object)data);
        return composite;
    }

    private List<BeansConfigLocatorDefinition> getEnabledBeansConfigLocatorDefinitions() {
        List<BeansConfigLocatorDefinition> builderDefinitions = this.beansConfigLocatorDefinitions;
        ArrayList<BeansConfigLocatorDefinition> filteredBuilderDefinitions = new ArrayList<BeansConfigLocatorDefinition>();
        for (BeansConfigLocatorDefinition builderDefinition : builderDefinitions) {
            if (!builderDefinition.isEnabled(this.project) || !builderDefinition.getBeansConfigLocator().supports(this.project)) continue;
            filteredBuilderDefinitions.add(builderDefinition);
        }
        return filteredBuilderDefinitions;
    }

    private List<BeansConfigLocatorDefinition> getGreyedBeansConfigLocatorDefinitions() {
        List<BeansConfigLocatorDefinition> builderDefinitions = this.beansConfigLocatorDefinitions;
        ArrayList<BeansConfigLocatorDefinition> filteredBuilderDefinitions = new ArrayList<BeansConfigLocatorDefinition>();
        for (BeansConfigLocatorDefinition builderDefinition : builderDefinitions) {
            if (builderDefinition.getBeansConfigLocator().supports(this.project)) continue;
            filteredBuilderDefinitions.add(builderDefinition);
        }
        return filteredBuilderDefinitions;
    }

    private void showDescription(BeansConfigLocatorDefinition definition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String text = "";
        if (!definition.getBeansConfigLocator().supports(this.project)) {
            text = "This configuration file detector does not support the current project!\n\r";
        }
        if ((text = String.valueOf(text) + definition.getDescription()) == null || text.length() == 0) {
            this.descriptionText.setText(SpringUIMessages.ProjectBuilderPropertyPage_noBuilderDescription);
        } else {
            this.descriptionText.setText(text);
        }
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    public boolean performOk() {
        if (Arrays.deepEquals(this.getEnabledBeansConfigLocatorDefinitions().toArray(), this.builderViewer.getCheckedElements())) {
            return true;
        }
        final List<Object> checkElements = Arrays.asList(this.builderViewer.getCheckedElements());
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                for (BeansConfigLocatorDefinition beansConfigLocatorDefinition : ConfigLocatorTab.this.beansConfigLocatorDefinitions) {
                    if (checkElements.contains(beansConfigLocatorDefinition)) {
                        beansConfigLocatorDefinition.setEnabled(true, ConfigLocatorTab.this.project);
                        continue;
                    }
                    beansConfigLocatorDefinition.setEnabled(false, ConfigLocatorTab.this.project);
                }
            }
        };
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private static class BeansConfigLocatorDefinitionContentProvider
    implements IStructuredContentProvider {
        private List<BeansConfigLocatorDefinition> beansConfigLocatorDefinitions;

        public BeansConfigLocatorDefinitionContentProvider(List<BeansConfigLocatorDefinition> projectBuilderDefinitions) {
            this.beansConfigLocatorDefinitions = projectBuilderDefinitions;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.beansConfigLocatorDefinitions.toArray();
        }
    }

    private class BeansConfigLocatorLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private BeansConfigLocatorLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof BeansConfigLocatorDefinition) {
                return ((BeansConfigLocatorDefinition)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof BeansConfigLocatorDefinition && !((BeansConfigLocatorDefinition)element).getBeansConfigLocator().supports(ConfigLocatorTab.this.project)) {
                return ConfigLocatorTab.this.grayColor;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            if (ConfigLocatorTab.this.grayColor != null) {
                ConfigLocatorTab.this.grayColor.dispose();
            }
        }
    }
}

