/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.navigator.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.part.FileEditorInput;
import org.springframework.ide.eclipse.config.core.schemas.WebFlowSchemaConstants;
import org.springframework.ide.eclipse.config.graph.AbstractConfigGraphicalEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public class OpenWebflowGraphAction
extends AbstractNavigatorAction {
    private IFile file;

    public OpenWebflowGraphAction(ICommonActionExtensionSite site) {
        super(site);
        this.setText("Open &Graphical Editor");
        this.setImageDescriptor(WebflowUIImages.DESC_OBJS_WEBFLOW);
    }

    public boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object sElement = selection.getFirstElement();
            if (sElement instanceof IWebflowConfig) {
                this.file = ((IWebflowConfig)sElement).getResource();
                return true;
            }
            if (sElement instanceof IFile && WebflowModelUtils.isWebflowConfig((IResource)((IFile)sElement))) {
                this.file = (IFile)sElement;
                return true;
            }
        }
        return false;
    }

    public void run() {
        AbstractConfigEditor cEditor;
        AbstractConfigGraphicalEditor graph;
        FileEditorInput input = new FileEditorInput(this.file);
        IEditorPart part = SpringUIUtils.openInEditor((IEditorInput)input, (String)"com.springsource.sts.config.ui.editors.SpringWebFlowEditor");
        if (part instanceof AbstractConfigEditor && (graph = (cEditor = (AbstractConfigEditor)part).getGraphicalEditorForUri(WebFlowSchemaConstants.URI)) != null) {
            cEditor.setActiveEditor((IEditorPart)graph);
        }
    }
}

