/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.ui.views.properties.IPropertySource;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class Property
extends Node
implements IAdaptable {
    private Bean bean;
    private IBeanProperty property;

    public Property(Bean bean, IBeanProperty property) {
        super((Object)property.getElementName());
        this.bean = bean;
        this.property = property;
    }

    public Bean getBean() {
        return this.bean;
    }

    public IBeanProperty getBeanProperty() {
        return this.property;
    }

    public String getName() {
        return this.property.getElementName();
    }

    public List<Object> getBeanReferences() {
        ArrayList<Object> references = new ArrayList<Object>();
        this.addReferencesForValue(this.property.getValue(), references);
        return references;
    }

    private void addReferencesForValue(Object value, List<Object> references) {
        block13: {
            block12: {
                if (!(value instanceof BeanDefinitionHolder)) break block12;
                String beanName = ((BeanDefinitionHolder)value).getBeanName();
                IBean modelBean = this.bean.getBean();
                String propertyName = this.getName();
                IBean innerBean = null;
                for (IBean iBean : BeansModelUtils.getInnerBeans((IModelElement)modelBean)) {
                    IModelElement parent;
                    if (!iBean.getElementName().equals(beanName) || !((parent = iBean.getElementParent()) instanceof IBeanProperty) || !parent.getElementName().equals(propertyName)) continue;
                    innerBean = iBean;
                    break;
                }
                if (innerBean == null) break block13;
                Iterator refBeans = BeansModelUtils.getBeanReferences(innerBean, (IModelElement)BeansModelUtils.getConfig(innerBean), (boolean)false).iterator();
                while (refBeans.hasNext()) {
                    String refBeanName = ((IBean)refBeans.next()).getElementName();
                    references.add(new RuntimeBeanReference(refBeanName));
                }
                break block13;
            }
            if (value instanceof RuntimeBeanReference) {
                references.add(value);
            } else if (value instanceof List) {
                List list = (List)value;
                int i = 0;
                while (i < list.size()) {
                    this.addReferencesForValue(list.get(i), references);
                    ++i;
                }
            } else if (value instanceof Set) {
                Set set = (Set)value;
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    this.addReferencesForValue(iter.next(), references);
                }
            } else if (value instanceof Map) {
                Map map = (Map)value;
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    this.addReferencesForValue(map.get(iter.next()), references);
                }
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return BeansUIUtils.getPropertySource((IModelElement)this.property);
        }
        return null;
    }
}

