/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph.model;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBean;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansContext;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansGroup;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansModel;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansResource;
import org.springframework.ide.eclipse.beans.ui.livegraph.model.LiveBeansSession;

public class LiveBeansJsonParser {
    private final LiveBeansSession session;
    private final String jsonInput;
    private Map<String, LiveBean> beansMap;
    private Map<String, LiveBeansContext> contextMap;
    private Map<String, LiveBeansGroup> resourceMap;

    public LiveBeansJsonParser(LiveBeansSession session, String jsonInput) {
        this.jsonInput = jsonInput;
        this.session = session;
    }

    private void groupByResource() {
        for (LiveBean bean : this.beansMap.values()) {
            LiveBeansGroup group;
            String resource = bean.getResource();
            if (this.resourceMap.containsKey(resource)) {
                group = this.resourceMap.get(resource);
                group.addBean(bean);
                continue;
            }
            group = new LiveBeansResource(resource);
            group.addBean(bean);
            this.resourceMap.put(resource, group);
        }
    }

    public LiveBeansModel parse() throws JSONException {
        this.beansMap = new HashMap<String, LiveBean>();
        this.contextMap = new HashMap<String, LiveBeansContext>();
        this.resourceMap = new HashMap<String, LiveBeansGroup>();
        JSONArray contextsArray = new JSONArray(this.jsonInput);
        this.parseContexts(contextsArray);
        this.populateContextDependencies(contextsArray);
        this.groupByResource();
        LiveBeansModel model = new LiveBeansModel(this.session);
        model.addBeans(this.beansMap.values());
        model.addContexts(this.contextMap.values());
        model.addResources(this.resourceMap.values());
        return model;
    }

    private void parseBeans(LiveBeansContext context, JSONArray beansArray) throws JSONException {
        int i = 0;
        while (i < beansArray.length()) {
            JSONObject beanJson = beansArray.getJSONObject(i);
            if (beanJson != null && beanJson.has("bean")) {
                LiveBean bean = new LiveBean(this.session, beanJson.getString("bean"));
                bean.addAttribute("context", context.getLabel());
                if (beanJson.has("scope")) {
                    bean.addAttribute("scope", beanJson.getString("scope"));
                }
                if (beanJson.has("type")) {
                    bean.addAttribute("type", beanJson.getString("type"));
                }
                if (beanJson.has("resource")) {
                    bean.addAttribute("resource", beanJson.getString("resource"));
                }
                if (this.session.getApplicationName() != null) {
                    bean.addAttribute("application name", this.session.getApplicationName());
                }
                context.addBean(bean);
                this.beansMap.put(bean.getId(), bean);
            }
            ++i;
        }
    }

    private void parseContexts(JSONArray contextsArray) throws JSONException {
        int i = 0;
        while (i < contextsArray.length()) {
            JSONObject contextJson = contextsArray.optJSONObject(i);
            if (contextJson != null) {
                LiveBeansContext context = new LiveBeansContext(contextJson.getString("context"));
                JSONArray beansArray = contextJson.optJSONArray("beans");
                if (beansArray != null) {
                    this.parseBeans(context, beansArray);
                }
                this.contextMap.put(context.getLabel(), context);
            }
            ++i;
        }
    }

    private void populateBeanDependencies(JSONArray beansArray) throws JSONException {
        int i = 0;
        while (i < beansArray.length()) {
            JSONObject beanJson = beansArray.optJSONObject(i);
            if (beanJson != null && beanJson.has("bean")) {
                LiveBean bean = this.beansMap.get(beanJson.getString("bean"));
                JSONArray dependencies = beanJson.optJSONArray("dependencies");
                if (dependencies != null) {
                    int j = 0;
                    while (j < dependencies.length()) {
                        String dependency = dependencies.getString(j);
                        LiveBean dependencyBean = this.beansMap.get(dependency);
                        if (dependencyBean != null) {
                            bean.addDependency(dependencyBean);
                        } else {
                            LiveBean dependentBean = new LiveBean(this.session, dependency, true);
                            if (this.session.getApplicationName() != null) {
                                dependentBean.addAttribute("application name", this.session.getApplicationName());
                            }
                            bean.addDependency(dependentBean);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void populateContextDependencies(JSONArray contextsArray) throws JSONException {
        int i = 0;
        while (i < contextsArray.length()) {
            JSONObject contextJson = contextsArray.optJSONObject(i);
            if (contextJson != null) {
                JSONArray beansArray;
                String parent;
                LiveBeansContext parentContext;
                LiveBeansContext context = this.contextMap.get(contextJson.getString("context"));
                if (!contextJson.isNull("parent") && (parentContext = this.contextMap.get(parent = contextJson.getString("parent"))) != null) {
                    context.setParent(parentContext);
                }
                if ((beansArray = contextJson.optJSONArray("beans")) != null) {
                    this.populateBeanDependencies(beansArray);
                }
            }
            ++i;
        }
    }
}

