/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.MultiSelectionFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.CommentSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class CheckBoxesSection<T>
extends WizardPageSection {
    private final MultiSelectionFieldModel<T> model;
    private Group group;
    private WizardPageSection[] subsections;
    private int numCols;

    public CheckBoxesSection(IPageWithSections owner, MultiSelectionFieldModel<T> model) {
        super(owner);
        this.model = model;
    }

    public CheckBoxesSection<T> columns(int howMany) {
        Assert.isLegal((howMany > 0 ? 1 : 0) != 0);
        this.numCols = howMany;
        return this;
    }

    protected GridLayout createLayout() {
        return new GridLayout(this.numCols, true);
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.model.getValidator();
    }

    public void createContents(Composite page) {
        this.group = new Group(page, 0);
        this.group.setText(this.model.getLabel());
        GridLayout layout = this.createLayout();
        this.group.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.group);
        T[] options = this.model.getChoices();
        this.subsections = new WizardPageSection[Math.max(1, options.length)];
        if (options.length == 0) {
            this.subsections[0] = new CommentSection(this.owner, "No choices available");
            this.subsections[0].createContents((Composite)this.group);
        }
        int i = 0;
        while (i < options.length) {
            T option = options[i];
            this.subsections[i] = new CheckBox(this.owner, option, this.model.getLabel(option), this.model.getTooltip(option), this.model.getEnablement(option));
            this.subsections[i].createContents((Composite)this.group);
            ++i;
        }
    }

    private class CheckBox
    extends WizardPageSection {
        private Button cb;
        private final T value;
        private final String label;
        private final String tooltip;
        private LiveExpression<Boolean> enablement;

        public CheckBox(IPageWithSections owner, T value, String label, String tooltip, LiveExpression<Boolean> enablement) {
            this(owner, value, label, tooltip);
            this.enablement = enablement;
        }

        public CheckBox(IPageWithSections owner, T value, String label, String tooltip) {
            super(owner);
            this.value = value;
            this.label = label;
            this.tooltip = tooltip;
        }

        public LiveExpression<ValidationResult> getValidator() {
            return Validator.OK;
        }

        public void createContents(Composite page) {
            if (page != null && !page.isDisposed()) {
                this.cb = new Button(page, 32);
                this.cb.setText(this.label);
                if (this.tooltip != null) {
                    this.cb.setToolTipText(this.tooltip);
                }
                this.cb.setSelection(CheckBoxesSection.this.model.getSelecteds().contains(this.value));
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.cb);
                this.cb.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.handleSelection();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.handleSelection();
                    }

                    private void handleSelection() {
                        boolean add = CheckBox.this.cb.getSelection();
                        if (add) {
                            CheckBoxesSection.this.model.add(CheckBox.this.value);
                        } else {
                            CheckBoxesSection.this.model.remove(CheckBox.this.value);
                        }
                    }
                });
                if (this.enablement != null) {
                    this.enablement.addListener((ValueListener)new ValueListener<Boolean>(){

                        public void gotValue(LiveExpression<Boolean> exp, Boolean value) {
                            if (value != null) {
                                CheckBox.this.cb.setEnabled(value.booleanValue());
                            }
                        }
                    });
                }
            }
        }

        public void dispose() {
            if (this.cb != null && !this.cb.isDisposed()) {
                this.cb.dispose();
                this.cb = null;
            }
        }
    }
}

