/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.ui.properties;

import java.util.LinkedList;
import java.util.List;
import net.sf.eclipsecs.core.config.CheckConfigurationWorkingCopy;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.projectconfig.FileMatchPattern;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import net.sf.eclipsecs.ui.CheckstyleUIPlugin;
import net.sf.eclipsecs.ui.CheckstyleUIPluginImages;
import net.sf.eclipsecs.ui.Messages;
import net.sf.eclipsecs.ui.config.CheckConfigurationConfigureDialog;
import net.sf.eclipsecs.ui.config.CheckConfigurationLabelProvider;
import net.sf.eclipsecs.ui.config.CheckConfigurationViewerSorter;
import net.sf.eclipsecs.ui.properties.CheckConfigurationContentProvider;
import net.sf.eclipsecs.ui.properties.CheckstylePropertyPage;
import net.sf.eclipsecs.ui.properties.FileMatchPatternEditDialog;
import net.sf.eclipsecs.ui.util.SWTUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileSetEditDialog
extends TitleAreaDialog {
    private static final String DEFAULT_PATTERN = ".java$";
    private final IProject mProject;
    private Text mFileSetNameText;
    private ComboViewer mComboViewer;
    private CheckboxTableViewer mPatternViewer;
    private TableViewer mMatchesViewer;
    private Group mMatchGroup;
    private Button mConfigureButton;
    private Button mAddButton;
    private Button mEditButton;
    private Button mRemoveButton;
    private Button mUpButton;
    private Button mDownButton;
    private final Controller mController = new Controller();
    private FileSet mFileSet;
    private List<IFile> mProjectFiles;
    private boolean mIsCreatingNewFileset;
    private final CheckstylePropertyPage mPropertyPage;

    FileSetEditDialog(Shell parent, FileSet fileSet, IProject project, CheckstylePropertyPage propsPage) throws CheckstylePluginException {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.mProject = project;
        this.mFileSet = fileSet;
        this.mPropertyPage = propsPage;
        if (this.mFileSet == null) {
            this.mFileSet = new FileSet();
            this.mFileSet.getFileMatchPatterns().add(new FileMatchPattern(DEFAULT_PATTERN));
            this.mIsCreatingNewFileset = true;
        }
    }

    public FileSet getFileSet() {
        return this.mFileSet;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(1808));
        Composite dialog = new Composite(composite, 0);
        dialog.setLayout((Layout)new GridLayout(1, false));
        dialog.setLayoutData((Object)new GridData(1808));
        Control commonArea = this.createCommonArea(dialog);
        commonArea.setLayoutData((Object)new GridData(768));
        SashForm sashForm = new SashForm(dialog, 512);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 400;
        sashForm.setLayoutData((Object)gd);
        sashForm.setLayout((Layout)new GridLayout());
        Control patternArea = this.createFileMatchPatternPart((Composite)sashForm);
        patternArea.setLayoutData((Object)new GridData(1808));
        Control matchArea = this.createTestArea((Composite)sashForm);
        matchArea.setLayoutData((Object)new GridData(1808));
        sashForm.setWeights(new int[]{50, 50});
        this.initializeControls();
        return composite;
    }

    private Control createCommonArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.FileSetEditDialog_lblName);
        this.mFileSetNameText = new Text(composite, 2052);
        this.mFileSetNameText.setLayoutData((Object)new GridData(768));
        Label lblConfiguration = new Label(composite, 0);
        lblConfiguration.setText(Messages.FileSetEditDialog_lblCheckConfig);
        Composite comboComposite = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comboComposite.setLayout((Layout)layout);
        comboComposite.setLayoutData((Object)new GridData(768));
        this.mComboViewer = new ComboViewer(comboComposite);
        this.mComboViewer.getCombo().setVisibleItemCount(10);
        this.mComboViewer.setContentProvider((IContentProvider)new CheckConfigurationContentProvider());
        this.mComboViewer.setLabelProvider((IBaseLabelProvider)new CheckConfigurationLabelProvider());
        this.mComboViewer.setSorter((ViewerSorter)new CheckConfigurationViewerSorter());
        this.mComboViewer.getControl().setLayoutData((Object)new GridData(768));
        this.mComboViewer.addSelectionChangedListener((ISelectionChangedListener)this.mController);
        this.mConfigureButton = new Button(comboComposite, 8);
        this.mConfigureButton.setText(Messages.FileSetEditDialog_btnConfigure);
        this.mConfigureButton.addSelectionListener((SelectionListener)this.mController);
        this.mConfigureButton.setLayoutData((Object)new GridData());
        return composite;
    }

    private Control createFileMatchPatternPart(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(Messages.FileSetEditDialog_titlePatternsTable);
        composite.setLayout((Layout)new FormLayout());
        Composite buttons = new Composite((Composite)composite, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment(100, -3);
        buttons.setLayoutData((Object)fd);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Table table = new Table((Composite)composite, 67616);
        fd = new FormData();
        fd.left = new FormAttachment(0, 3);
        fd.top = new FormAttachment(0, 3);
        fd.right = new FormAttachment((Control)buttons, -3, 16384);
        fd.bottom = new FormAttachment(100, -3);
        table.setLayoutData((Object)fd);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.FileSetEditDialog_colInclude);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(11));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.FileSetEditDialog_colRegex);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(89));
        this.mPatternViewer = new CheckboxTableViewer(table);
        this.mPatternViewer.setLabelProvider((IBaseLabelProvider)new FileMatchPatternLabelProvider());
        this.mPatternViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mPatternViewer.addDoubleClickListener((IDoubleClickListener)this.mController);
        this.mPatternViewer.addCheckStateListener((ICheckStateListener)this.mController);
        this.mAddButton = this.createPushButton(buttons, Messages.FileSetEditDialog_btnAdd);
        this.mAddButton.addSelectionListener((SelectionListener)this.mController);
        this.mEditButton = this.createPushButton(buttons, Messages.FileSetEditDialog_btnEdit);
        this.mEditButton.addSelectionListener((SelectionListener)this.mController);
        this.mRemoveButton = this.createPushButton(buttons, Messages.FileSetEditDialog_btnRemove);
        this.mRemoveButton.addSelectionListener((SelectionListener)this.mController);
        this.mUpButton = this.createPushButton(buttons, Messages.FileSetEditDialog_btnUp);
        this.mUpButton.addSelectionListener((SelectionListener)this.mController);
        this.mDownButton = this.createPushButton(buttons, Messages.FileSetEditDialog_btnDown);
        this.mDownButton.addSelectionListener((SelectionListener)this.mController);
        return composite;
    }

    private Control createTestArea(Composite parent) {
        this.mMatchGroup = new Group(parent, 0);
        this.mMatchGroup.setLayout((Layout)new GridLayout(1, false));
        this.mMatchesViewer = new TableViewer((Composite)this.mMatchGroup);
        this.mMatchesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mMatchesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final WorkbenchLabelProvider mDelegate = new WorkbenchLabelProvider();

            public String getText(Object element) {
                String text = "";
                if (element instanceof IFile) {
                    text = ((IFile)element).getProjectRelativePath().toString();
                }
                return text;
            }

            public Image getImage(Object element) {
                return this.mDelegate.getImage(element);
            }
        });
        this.mMatchesViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return FileSetEditDialog.this.mFileSet.includesFile((IFile)element);
                }
                return false;
            }
        });
        this.mMatchesViewer.getControl().setLayoutData((Object)new GridData(1808));
        return this.mMatchGroup;
    }

    private void initializeControls() {
        this.mComboViewer.setInput((Object)this.mPropertyPage.getProjectConfigurationWorkingCopy());
        this.setTitleImage(CheckstyleUIPluginImages.getImage(CheckstyleUIPluginImages.PLUGIN_LOGO));
        this.setMessage(Messages.FileSetEditDialog_message);
        if (this.mIsCreatingNewFileset) {
            this.setTitle(Messages.FileSetEditDialog_titleCreate);
        } else {
            this.setTitle(Messages.FileSetEditDialog_titleEdit);
        }
        this.mFileSetNameText.setText(this.mFileSet.getName() != null ? this.mFileSet.getName() : "");
        if (this.mFileSet.getCheckConfig() != null) {
            this.mComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.mFileSet.getCheckConfig()));
        }
        this.mPatternViewer.setInput((Object)this.mFileSet.getFileMatchPatterns());
        for (FileMatchPattern pattern : this.mFileSet.getFileMatchPatterns()) {
            this.mPatternViewer.setChecked((Object)pattern, pattern.isIncludePattern());
        }
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                FileSetEditDialog.this.mMatchGroup.setText(Messages.FileSetEditDialog_msgBuildTestResults);
                try {
                    FileSetEditDialog.this.mProjectFiles = FileSetEditDialog.this.getFiles((IContainer)FileSetEditDialog.this.mProject);
                }
                catch (CoreException e) {
                    CheckstyleLog.log((Throwable)e);
                }
                FileSetEditDialog.this.mMatchesViewer.setInput((Object)FileSetEditDialog.this.mProjectFiles);
                FileSetEditDialog.this.updateMatchView();
            }
        });
    }

    private void updateMatchView() {
        this.mMatchesViewer.refresh();
        this.mMatchGroup.setText(NLS.bind((String)Messages.FileSetEditDialog_titleTestResult, (Object[])new String[]{this.mProject.getName(), "" + this.mMatchesViewer.getTable().getItemCount(), "" + this.mProjectFiles.size()}));
    }

    public void create() {
        super.create();
        SWTUtil.addResizeSupport((Dialog)this, CheckstyleUIPlugin.getDefault().getDialogSettings(), FileSetEditDialog.class.getName());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.FileSetEditDialog_titleFilesetEditor);
    }

    protected void okPressed() {
        String name = this.mFileSetNameText.getText();
        if (name == null || name.trim().length() <= 0) {
            this.setErrorMessage(Messages.FileSetEditDialog_msgNoFilesetName);
            return;
        }
        if (this.mFileSet.getCheckConfig() == null) {
            this.setErrorMessage(Messages.FileSetEditDialog_noCheckConfigSelected);
            return;
        }
        this.mFileSet.setName(name);
        super.okPressed();
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    private void addFileMatchPattern() {
        FileMatchPatternEditDialog dialog = new FileMatchPatternEditDialog(this.getShell(), null);
        if (dialog.open() == 0) {
            FileMatchPattern pattern = dialog.getPattern();
            this.mFileSet.getFileMatchPatterns().add(pattern);
            this.mPatternViewer.refresh();
            this.mPatternViewer.setChecked((Object)pattern, pattern.isIncludePattern());
        }
    }

    private void editFileMatchPattern() {
        IStructuredSelection selection = (IStructuredSelection)this.mPatternViewer.getSelection();
        FileMatchPattern pattern = (FileMatchPattern)selection.getFirstElement();
        if (pattern == null) {
            return;
        }
        FileMatchPatternEditDialog dialog = new FileMatchPatternEditDialog(this.getShell(), pattern.clone());
        if (dialog.open() == 0) {
            FileMatchPattern editedPattern = dialog.getPattern();
            this.mFileSet.getFileMatchPatterns().set(this.mFileSet.getFileMatchPatterns().indexOf(pattern), editedPattern);
            this.mPatternViewer.refresh();
            this.mPatternViewer.setChecked((Object)editedPattern, editedPattern.isIncludePattern());
        }
    }

    private void removeFileMatchPattern() {
        IStructuredSelection selection = (IStructuredSelection)this.mPatternViewer.getSelection();
        FileMatchPattern pattern = (FileMatchPattern)selection.getFirstElement();
        if (pattern == null) {
            return;
        }
        this.mFileSet.getFileMatchPatterns().remove(pattern);
        this.mPatternViewer.refresh();
    }

    private void upFileMatchPattern() {
        IStructuredSelection selection = (IStructuredSelection)this.mPatternViewer.getSelection();
        FileMatchPattern pattern = (FileMatchPattern)selection.getFirstElement();
        if (pattern == null) {
            return;
        }
        int index = this.mFileSet.getFileMatchPatterns().indexOf(pattern);
        if (index > 0) {
            this.mFileSet.getFileMatchPatterns().remove(pattern);
            this.mFileSet.getFileMatchPatterns().add(index - 1, pattern);
            this.mPatternViewer.refresh();
        }
    }

    private void downFileMatchPattern() {
        IStructuredSelection selection = (IStructuredSelection)this.mPatternViewer.getSelection();
        FileMatchPattern pattern = (FileMatchPattern)selection.getFirstElement();
        if (pattern == null) {
            return;
        }
        int index = this.mFileSet.getFileMatchPatterns().indexOf(pattern);
        if (index >= 0 && index < this.mFileSet.getFileMatchPatterns().size() - 1) {
            this.mFileSet.getFileMatchPatterns().remove(pattern);
            if (index < this.mFileSet.getFileMatchPatterns().size() - 1) {
                this.mFileSet.getFileMatchPatterns().add(index + 1, pattern);
            } else {
                this.mFileSet.getFileMatchPatterns().add(pattern);
            }
            this.mPatternViewer.refresh();
        }
    }

    private List<IFile> getFiles(IContainer container) throws CoreException {
        LinkedList<IFile> files = new LinkedList<IFile>();
        LinkedList<IFolder> folders = new LinkedList<IFolder>();
        IResource[] children = container.members();
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            int childType = child.getType();
            if (childType == 1) {
                files.add((IFile)child);
            } else if (childType == 2) {
                folders.add((IFolder)child);
            }
            ++i;
        }
        for (IFolder folder : folders) {
            files.addAll(this.getFiles((IContainer)folder));
        }
        return files;
    }

    private class Controller
    implements SelectionListener,
    IDoubleClickListener,
    ICheckStateListener,
    ISelectionChangedListener {
        private Controller() {
        }

        public void widgetSelected(SelectionEvent e) {
            ICheckConfiguration config;
            if (e.widget == FileSetEditDialog.this.mAddButton) {
                FileSetEditDialog.this.addFileMatchPattern();
                FileSetEditDialog.this.updateMatchView();
            } else if (e.widget == FileSetEditDialog.this.mEditButton) {
                FileSetEditDialog.this.editFileMatchPattern();
                FileSetEditDialog.this.updateMatchView();
            } else if (e.widget == FileSetEditDialog.this.mRemoveButton) {
                FileSetEditDialog.this.removeFileMatchPattern();
                FileSetEditDialog.this.updateMatchView();
            } else if (e.widget == FileSetEditDialog.this.mUpButton) {
                FileSetEditDialog.this.upFileMatchPattern();
                FileSetEditDialog.this.updateMatchView();
            } else if (e.widget == FileSetEditDialog.this.mDownButton) {
                FileSetEditDialog.this.downFileMatchPattern();
                FileSetEditDialog.this.updateMatchView();
            } else if (e.widget == FileSetEditDialog.this.mConfigureButton && (config = FileSetEditDialog.this.mFileSet.getCheckConfig()) != null) {
                IProject project = (IProject)FileSetEditDialog.this.mPropertyPage.getElement();
                try {
                    config.getCheckstyleConfiguration();
                    CheckConfigurationWorkingCopy workingCopy = (CheckConfigurationWorkingCopy)config;
                    CheckConfigurationConfigureDialog dialog = new CheckConfigurationConfigureDialog(FileSetEditDialog.this.getShell(), workingCopy);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
                catch (CheckstylePluginException ex) {
                    CheckstyleUIPlugin.warningDialog(FileSetEditDialog.this.mPropertyPage.getShell(), NLS.bind((String)Messages.CheckstylePreferencePage_msgProjectRelativeConfigNoFound, (Object)project, (Object)config.getLocation()), ex);
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void doubleClick(DoubleClickEvent event) {
            FileSetEditDialog.this.editFileMatchPattern();
            FileSetEditDialog.this.updateMatchView();
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (event.getElement() instanceof FileMatchPattern) {
                FileMatchPattern pattern = (FileMatchPattern)event.getElement();
                pattern.setIsIncludePattern(event.getChecked());
                FileSetEditDialog.this.mPatternViewer.refresh();
                FileSetEditDialog.this.updateMatchView();
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            ICheckConfiguration config = (ICheckConfiguration)selection.getFirstElement();
            FileSetEditDialog.this.mFileSet.setCheckConfig(config);
        }
    }

    class FileMatchPatternLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        FileMatchPatternLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = element.toString();
            if (element instanceof FileMatchPattern) {
                FileMatchPattern pattern = (FileMatchPattern)element;
                switch (columnIndex) {
                    case 0: {
                        result = new String();
                        break;
                    }
                    case 1: {
                        result = pattern.getMatchPattern();
                        break;
                    }
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

