/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.core.client;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.eclipse.internal.core.CoreMessages;
import com.atlassian.connector.eclipse.internal.core.client.HttpSessionCallbackImpl;
import com.atlassian.connector.eclipse.internal.core.client.RemoteOperation;
import com.atlassian.connector.eclipse.internal.core.client.RemoteSessionOperation;
import com.atlassian.theplugin.commons.crucible.api.CrucibleLoginException;
import com.atlassian.theplugin.commons.exception.ServerPasswordNotProvidedException;
import com.atlassian.theplugin.commons.remoteapi.CaptchaRequiredException;
import com.atlassian.theplugin.commons.remoteapi.ProductServerFacade;
import com.atlassian.theplugin.commons.remoteapi.ProductSession;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectorClient<F extends ProductServerFacade, S extends ProductSession> {
    protected final F facade;
    protected AbstractWebLocation location;
    protected ConnectionCfg connectionCfg;
    private final HttpSessionCallbackImpl callback;

    public AbstractConnectorClient(AbstractWebLocation location, ConnectionCfg connectionCfg, F facade, HttpSessionCallbackImpl callback) {
        this.location = location;
        this.connectionCfg = connectionCfg;
        this.facade = facade;
        this.callback = callback;
    }

    public String getUsername() {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            return credentials.getUserName();
        }
        return null;
    }

    public <T> T execute(RemoteOperation<T, F> op) throws CoreException {
        return this.execute(op, true);
    }

    public <T> T execute(RemoteSessionOperation<T, S> op) throws CoreException {
        return this.execute(op, true);
    }

    private <T> T executeRetry(RemoteSessionOperation<T, S> op, IProgressMonitor monitor, Exception e) throws CoreException {
        try {
            this.location.requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
        }
        catch (UnsupportedRequestException unsupportedRequestException) {
            throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.core", 3, e.getMessage(), (Throwable)e));
        }
        return this.execute(op);
    }

    public final <T> T execute(RemoteSessionOperation<T, S> op, boolean promptForCredentials) throws CoreException {
        IProgressMonitor monitor = op.getMonitor();
        TaskRepository taskRepository = op.getTaskRepository();
        try {
            AuthenticationCredentials creds = taskRepository.getCredentials(AuthenticationType.REPOSITORY);
            if (creds != null && creds.getPassword().length() < 1 && promptForCredentials) {
                try {
                    this.location.requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
                }
                catch (UnsupportedRequestException unsupportedRequestException) {}
            }
            monitor.beginTask("Connecting to " + this.facade.getServerType().getShortName(), -1);
            this.updateServer();
            this.callback.updateHostConfiguration(this.location, this.connectionCfg);
            T t = op.run(this.getSession(this.connectionCfg), op.getMonitor());
            return t;
        }
        catch (CrucibleLoginException e) {
            T t = this.executeRetry(op, monitor, (Exception)((Object)e));
            return t;
        }
        catch (RemoteApiLoginException e) {
            if (e.getCause() instanceof IOException) {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.core", e.getMessage(), (Throwable)e));
            }
            T t = this.executeRetry(op, monitor, (Exception)((Object)e));
            return t;
        }
        catch (ServerPasswordNotProvidedException e) {
            T t = this.executeRetry(op, monitor, (Exception)((Object)e));
            return t;
        }
        catch (RemoteApiException e) {
            throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.core", e.getMessage(), (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    protected abstract S getSession(ConnectionCfg var1) throws RemoteApiException, ServerPasswordNotProvidedException;

    public final <T> T execute(RemoteOperation<T, F> op, boolean promptForCredentials) throws CoreException {
        IProgressMonitor monitor = op.getMonitor();
        TaskRepository taskRepository = op.getTaskRepository();
        try {
            AuthenticationCredentials creds = taskRepository.getCredentials(AuthenticationType.REPOSITORY);
            if (creds != null && creds.getPassword().length() < 1 && promptForCredentials) {
                try {
                    this.location.requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
                }
                catch (UnsupportedRequestException unsupportedRequestException) {}
            }
            monitor.beginTask("Connecting to " + this.facade.getServerType().getShortName(), -1);
            this.updateServer();
            this.callback.updateHostConfiguration(this.location, this.connectionCfg);
            T t = op.run(this.facade, this.connectionCfg, op.getMonitor());
            return t;
        }
        catch (CrucibleLoginException e) {
            T t = this.executeRetry(op, monitor, (Exception)((Object)e));
            return t;
        }
        catch (CaptchaRequiredException e) {
            throw new CoreException((IStatus)new RepositoryStatus(4, "com.atlassian.connector.eclipse.core", 3, CoreMessages.Captcha_authentication_required, (Throwable)e));
        }
        catch (RemoteApiLoginException e) {
            if (e.getCause() instanceof IOException) {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.core", e.getMessage(), (Throwable)e));
            }
            T t = this.executeRetry(op, monitor, (Exception)((Object)e));
            return t;
        }
        catch (ServerPasswordNotProvidedException e) {
            T t = this.executeRetry(op, monitor, (Exception)((Object)e));
            return t;
        }
        catch (RemoteApiException e) {
            throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.core", e.getMessage(), (Throwable)e));
        }
        finally {
            monitor.done();
        }
    }

    private <T> T executeRetry(RemoteOperation<T, F> op, IProgressMonitor monitor, Exception e) throws CoreException {
        try {
            this.location.requestCredentials(AuthenticationType.REPOSITORY, null, monitor);
        }
        catch (UnsupportedRequestException unsupportedRequestException) {
            throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.core", 3, e.getMessage(), (Throwable)e));
        }
        return this.execute(op);
    }

    protected void updateServer() {
        AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
        if (credentials != null) {
            this.connectionCfg = new ConnectionCfg(this.connectionCfg.getId(), this.connectionCfg.getUrl(), credentials.getUserName(), credentials.getPassword());
        }
    }

    public void validate(IProgressMonitor monitor, TaskRepository taskRepository) throws CoreException {
        this.execute(new RemoteOperation<Void, F>(monitor, taskRepository){

            @Override
            public Void run(F server, ConnectionCfg serverCfg, IProgressMonitor monitor) throws CrucibleLoginException, RemoteApiException, ServerPasswordNotProvidedException {
                server.testServerConnection(serverCfg);
                return null;
            }
        });
    }

    public void updateLocation(AbstractWebLocation newLocation) {
        this.location = newLocation;
    }

    public ConnectionCfg getServerData() {
        return this.connectionCfg;
    }
}

