/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.integration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.integration.Activator;

public class IntegrationUiImages {
    private static final String ICON_PATH_PREFIX = "";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.integration.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.integration.".length();
    private static final String STRUCTURE = "icons/full/obj16/";
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OBJS_WS = "org.springframework.ide.eclipse.integration.spring-ws.gif";
    public static final String IMG_OBJS_FLEX = "org.springframework.ide.eclipse.integration.spring-flex.gif";
    public static final ImageDescriptor DESC_OBJS_WS;
    public static final ImageDescriptor DESC_OBJS_FLEX;

    static {
        try {
            ICON_BASE_URL = new URL(Activator.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException malformedURLException) {}
        DESC_OBJS_WS = IntegrationUiImages.createManaged(STRUCTURE, IMG_OBJS_WS);
        DESC_OBJS_FLEX = IntegrationUiImages.createManaged(STRUCTURE, IMG_OBJS_FLEX);
    }

    public static Image getImage(String key) {
        return IntegrationUiImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        IntegrationUiImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        IntegrationUiImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            for (String key : imageDescriptors.keySet()) {
                imageRegistry.put(key, imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)IntegrationUiImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        action.setImageDescriptor(IntegrationUiImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)IntegrationUiImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)IntegrationUiImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

