/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractEditorFactory;
import net.sourceforge.pmd.lang.rule.properties.CharacterProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CharacterEditorFactory
extends AbstractEditorFactory {
    public static final CharacterEditorFactory instance = new CharacterEditorFactory();

    private CharacterEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return new CharacterProperty(name, description, Character.valueOf('a'), 0.0f);
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        String value = ((Text)valueControl).getText().trim();
        return StringUtil.isEmpty((String)value) || value.length() > 1 ? null : Character.valueOf(value.charAt(0));
    }

    protected void fillWidget(Text textWidget, PropertyDescriptor<?> desc, PropertySource source) {
        Character val = (Character)this.valueFor(source, desc);
        textWidget.setText(val == null ? "" : val.toString());
    }

    private static Character charValueIn(Text textControl) {
        String newValue = textControl.getText().trim();
        if (newValue.length() == 0) {
            return null;
        }
        return Character.valueOf(newValue.charAt(0));
    }

    private static CharacterProperty characterPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (CharacterProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (CharacterProperty)desc;
    }

    @Override
    public Control newEditorOn(Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener, SizeChangeListener sizeListener) {
        final Text text = new Text(parent, 2052);
        this.fillWidget(text, desc, source);
        final CharacterProperty cp = CharacterEditorFactory.characterPropertyFrom(desc);
        text.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                Character newValue = CharacterEditorFactory.charValueIn(text);
                Character existingValue = (Character)CharacterEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)cp);
                if (existingValue.equals(newValue)) {
                    return;
                }
                source.setProperty((PropertyDescriptor)cp, (Object)newValue);
                listener.changed(source, (PropertyDescriptor<?>)cp, (Object)newValue);
                CharacterEditorFactory.this.adjustRendering(source, desc, (Control)text);
            }
        });
        return text;
    }
}

