/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleGroup;
import net.sourceforge.pmd.eclipse.util.Util;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class RuleSetTreeItemProvider
implements ITreeContentProvider {
    private RuleFieldAccessor fieldAccessor;
    private final String groupDescription;
    private final Comparator comparator;
    private final Map<Object, RuleGroup> ruleGroups;

    public RuleSetTreeItemProvider(RuleFieldAccessor accessor, String description, Comparator<?> theComparator) {
        this.fieldAccessor = accessor;
        this.groupDescription = description;
        this.comparator = theComparator;
        this.ruleGroups = new HashMap<Object, RuleGroup>();
    }

    public void accessor(RuleFieldAccessor accessor) {
        this.fieldAccessor = accessor;
    }

    private Object[] sort(Collection<Rule> ruleColl) {
        Object[] rules = ruleColl.toArray();
        if (this.comparator == null) {
            return rules;
        }
        Arrays.sort(rules, this.comparator);
        return rules;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof RuleSet) {
            RuleSet ruleSet = (RuleSet)parentElement;
            return this.fieldAccessor == null ? this.sort(ruleSet.getRules()) : this.asRuleGroups(ruleSet.getRules());
        }
        if (parentElement instanceof RuleGroup) {
            RuleGroup ruleGroup = (RuleGroup)parentElement;
            return ruleGroup.rules();
        }
        return Util.EMPTY_ARRAY;
    }

    private RuleGroup[] asRuleGroups(Collection<Rule> rules) {
        Object[] groups;
        Iterator<Rule> iter = rules.iterator();
        this.ruleGroups.clear();
        while (iter.hasNext()) {
            Rule rule = iter.next();
            Comparable<?> groupId = this.fieldAccessor.valueFor(rule);
            RuleGroup group = this.ruleGroups.get(groupId);
            if (group != null) {
                group.add(rule);
                continue;
            }
            group = new RuleGroup(groupId, this.fieldAccessor.labelFor(rule), this.groupDescription);
            group.add(rule);
            this.ruleGroups.put(groupId, group);
        }
        Object[] objectArray = groups = this.ruleGroups.values().toArray(new RuleGroup[this.ruleGroups.size()]);
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Object group = objectArray[n2];
            ((RuleGroup)group).sortBy(this.comparator);
            ++n2;
        }
        Arrays.sort(groups);
        return groups;
    }

    private RuleGroup groupFor(Rule rule) {
        if (this.fieldAccessor == null) {
            return null;
        }
        Comparable<?> groupId = this.fieldAccessor.valueFor(rule);
        return this.ruleGroups.get(groupId);
    }

    public Object getParent(Object element) {
        if (element instanceof RuleGroup) {
            return null;
        }
        if (element instanceof Rule) {
            return this.groupFor((Rule)element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof RuleSet) {
            RuleSet ruleSet = (RuleSet)element;
            return ruleSet.getRules().size() > 0;
        }
        if (element instanceof RuleGroup) {
            return ((RuleGroup)element).hasRules();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}

