/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.status;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.status.IStatusCache;
import org.tigris.subversion.subclipse.core.status.StatusUpdateStrategy;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class RecursiveStatusUpdateStrategy
extends StatusUpdateStrategy {
    public RecursiveStatusUpdateStrategy(IStatusCache statusCache) {
        super(statusCache);
    }

    protected ISVNStatus[] statusesToUpdate(IResource resource) throws SVNException {
        IContainer parent;
        if (!(resource instanceof IProject) && (parent = resource.getParent()) != null && this.statusCache.getStatus((IResource)parent) == null) {
            return this.statusesToUpdate((IResource)parent);
        }
        if (Policy.DEBUG_STATUS) {
            System.out.println("[svn] getting status for : " + resource.getFullPath());
        }
        ISVNStatus[] statuses = null;
        ISVNClientAdapter svnClientAdapterStatus = null;
        try {
            try {
                SVNProviderPlugin.disableConsoleLogging();
                svnClientAdapterStatus = SVNProviderPlugin.getPlugin().getSVNClient();
                statuses = svnClientAdapterStatus.getStatus(resource.getLocation().toFile(), true, true);
            }
            catch (SVNClientException e1) {
                if (!e1.getMessage().contains("working copy needs to be upgraded")) {
                    throw SVNException.wrapException((Exception)((Object)e1));
                }
            }
        }
        finally {
            SVNProviderPlugin.enableConsoleLogging();
            SVNProviderPlugin.getPlugin().getSVNClientManager().returnSVNClient(svnClientAdapterStatus);
        }
        return this.collectUnversionedFolders(statuses, true);
    }
}

