/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.model.validation;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;

public class ValidationRuleDefinitionFactory {
    public static final String VALIDATORS_EXTENSION_POINT = "org.springframework.ide.eclipse.core.validators";
    public static final String RULES_ELEMENT = "rules";
    public static final String RULE_ELEMENT = "rule";
    public static final String VALIDATOR_ID_ATTRIBUTE = "validatorId";
    private static Map<String, Set<ValidationRuleDefinition>> validationRuleDefinitions = new HashMap<String, Set<ValidationRuleDefinition>>();

    public static synchronized Set<ValidationRuleDefinition> getRuleDefinitions(String validatorID) {
        if (!validationRuleDefinitions.containsKey(validatorID)) {
            LinkedHashSet<ValidationRuleDefinition> ruleDefinitions = new LinkedHashSet<ValidationRuleDefinition>();
            IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(VALIDATORS_EXTENSION_POINT).getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String id;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (RULES_ELEMENT.equals(element.getName()) && validatorID.equals(id = element.getAttribute(VALIDATOR_ID_ATTRIBUTE))) {
                        IConfigurationElement[] iConfigurationElementArray2 = element.getChildren(RULE_ELEMENT);
                        int n5 = iConfigurationElementArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement ruleElement = iConfigurationElementArray2[n6];
                            try {
                                ValidationRuleDefinition ruleDefinition = new ValidationRuleDefinition(validatorID, ruleElement);
                                ruleDefinitions.add(ruleDefinition);
                            }
                            catch (CoreException e) {
                                SpringCore.log(e);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            validationRuleDefinitions.put(validatorID, ruleDefinitions);
        }
        return validationRuleDefinitions.get(validatorID);
    }

    public static Set<ValidationRuleDefinition> getEnabledRuleDefinitions(String validatorID, IProject project) {
        LinkedHashSet<ValidationRuleDefinition> validationRuleDefinitions = new LinkedHashSet<ValidationRuleDefinition>();
        for (ValidationRuleDefinition validationRuleDefinition : ValidationRuleDefinitionFactory.getRuleDefinitions(validatorID)) {
            if (!validationRuleDefinition.isEnabled(project)) continue;
            validationRuleDefinitions.add(validationRuleDefinition);
        }
        return validationRuleDefinitions;
    }
}

