/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.history;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.util.LinkList;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class HistoryTableProvider {
    private ISVNRemoteResource currentRemoteResource;
    private SVNRevision.Number currentRevision;
    private TableViewer viewer;
    private Font currentRevisionFont;
    private boolean includeMergeRevisions = true;
    private boolean includeTags = true;
    private boolean includeBugs = false;
    private int style;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private String id;
    ProjectProperties projectProperties = null;
    private static final int COL_REVISION = 0;
    private static final int COL_MERGED_REVISIONS = 1;
    private static final int COL_TAGS = 2;
    private static final int COL_DATE = 3;
    private static final int COL_AUTHOR = 4;
    private static final int COL_COMMENT = 5;
    private static final int COL_BUGS = 6;

    public HistoryTableProvider() {
        this(66306, null);
    }

    public HistoryTableProvider(int style, String id) {
        this.style = style;
        this.id = id;
    }

    private String getBugstringFromComment(String comment) {
        String display = "";
        if (this.projectProperties != null) {
            LinkList ll = this.projectProperties.getLinkList(comment);
            String[] texts = ll.getTexts();
            int i = 0;
            while (texts != null && texts.length > i) {
                display = String.valueOf(display) + texts[i];
                display = String.valueOf(display) + " ";
                ++i;
            }
        }
        return display;
    }

    protected ILogEntry adaptToLogEntry(Object element) {
        ILogEntry entry = null;
        if (element instanceof ILogEntry) {
            entry = (ILogEntry)element;
        } else if (element instanceof IAdaptable) {
            entry = (ILogEntry)((IAdaptable)element).getAdapter(ILogEntry.class);
        }
        return entry;
    }

    public TableViewer createTable(Composite parent) {
        Table table = new Table(parent, this.style);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(table);
        this.createColumns(table, layout, viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new HistoryLabelProvider());
        HistorySorter sorter = new HistorySorter(0);
        viewer.setSorter((ViewerSorter)sorter);
        table.setSortDirection(1024);
        table.setSortColumn(table.getColumn(0));
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (HistoryTableProvider.this.currentRevisionFont != null) {
                    HistoryTableProvider.this.currentRevisionFont.dispose();
                }
            }
        });
        this.viewer = viewer;
        return viewer;
    }

    private void createColumns(Table table, TableLayout layout, TableViewer viewer) {
        DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableColumn col = (TableColumn)e.getSource();
                if (col.getWidth() > 0) {
                    HistoryTableProvider.this.settings.put("HistoryTableProvider." + HistoryTableProvider.this.id + "." + col.getText(), col.getWidth());
                }
            }
        };
        SelectionListener headerListener = this.getColumnListener(viewer);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.revision"));
        col.addSelectionListener(headerListener);
        this.setColumnWidth(layout, disposeListener, col, 10);
        table.setSortColumn(col);
        if (this.includeMergeRevisions) {
            col = new TableColumn(table, 0);
            col.setResizable(true);
            col.setText(Policy.bind("HistoryView.mergedRevisions"));
            col.addSelectionListener(headerListener);
            this.setColumnWidth(layout, disposeListener, col, 30);
        }
        if (this.includeTags) {
            col = new TableColumn(table, 0);
            col.setResizable(true);
            col.setText(Policy.bind("HistoryView.tags"));
            col.addSelectionListener(headerListener);
            this.setColumnWidth(layout, disposeListener, col, 30);
        }
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.date"));
        col.addSelectionListener(headerListener);
        this.setColumnWidth(layout, disposeListener, col, 25);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.author"));
        col.addSelectionListener(headerListener);
        this.setColumnWidth(layout, disposeListener, col, 20);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("HistoryView.comment"));
        col.addSelectionListener(headerListener);
        this.setColumnWidth(layout, disposeListener, col, 50);
        if (this.includeBugs) {
            col = new TableColumn(table, 0);
            col.setResizable(true);
            String label = this.projectProperties.getLabel();
            if (label != null && label.trim().length() > 0) {
                if ((label = label.trim()).endsWith(":")) {
                    label = label.substring(0, label.length() - 1);
                }
                col.setText(label);
            } else {
                col.setText(Policy.bind("HistoryView.bugs"));
            }
            col.addSelectionListener(headerListener);
            this.setColumnWidth(layout, disposeListener, col, 10);
        }
    }

    private void setColumnWidth(TableLayout layout, DisposeListener disposeListener, TableColumn col, int defaultWidth) {
        String columnWidth = null;
        if (this.id != null) {
            columnWidth = this.settings.get("HistoryTableProvider." + this.id + "." + col.getText());
        }
        if (columnWidth == null || columnWidth.equals("0")) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(defaultWidth, true));
        } else {
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(Integer.parseInt(columnWidth), true));
        }
        if (this.id != null) {
            col.addDisposeListener(disposeListener);
        }
    }

    private SelectionListener getColumnListener(final TableViewer tableViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<Object> checkedItems = new ArrayList<Object>();
                TableItem[] items = tableViewer.getTable().getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].getChecked()) {
                        checkedItems.add(items[i].getData());
                    }
                    ++i;
                }
                int column = tableViewer.getTable().indexOf((TableColumn)e.widget);
                HistoryTableProvider.this.setSortColumn(tableViewer, column);
                items = tableViewer.getTable().getItems();
                int i2 = 0;
                while (i2 < items.length) {
                    if (checkedItems.contains(items[i2].getData())) {
                        items[i2].setChecked(true);
                    }
                    ++i2;
                }
            }
        };
    }

    private SVNRevision.Number getRevision(ISVNRemoteResource currentEdition) {
        if (currentEdition == null) {
            return SVNRevision.INVALID_REVISION;
        }
        return currentEdition.getLastChangedRevision();
    }

    public void setRemoteResource(ISVNRemoteResource remoteResource) {
        this.currentRemoteResource = remoteResource;
        this.currentRevision = this.getRevision(remoteResource);
    }

    public SVNRevision.Number getCurrentRevision() {
        return this.currentRevision;
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.currentRemoteResource;
    }

    public void setIncludeMergeRevisions(boolean includeMergeRevisions) {
        this.includeMergeRevisions = includeMergeRevisions;
    }

    public void setIncludeTags(boolean includeTags) {
        this.includeTags = includeTags;
    }

    public boolean isIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeBugs(boolean includeBugs) {
        this.includeBugs = includeBugs;
    }

    public boolean isIncludeBugs() {
        return this.projectProperties != null;
    }

    public void setProjectProperties(ProjectProperties projectProperties) {
        this.projectProperties = projectProperties;
    }

    public void setSortColumn(TableViewer tableViewer, int column) {
        HistorySorter oldSorter = (HistorySorter)tableViewer.getSorter();
        if (oldSorter != null && column == oldSorter.getColumnNumber()) {
            oldSorter.setReversed(!oldSorter.isReversed());
            if (oldSorter.isReversed()) {
                tableViewer.getTable().setSortDirection(1024);
            } else {
                tableViewer.getTable().setSortDirection(128);
            }
            tableViewer.refresh();
        } else {
            HistorySorter newSorter = new HistorySorter(column);
            if (column == 0) {
                newSorter.setReversed(true);
            }
            tableViewer.setSorter((ViewerSorter)newSorter);
            if (column == 0) {
                tableViewer.getTable().setSortDirection(1024);
            } else {
                tableViewer.getTable().setSortDirection(128);
            }
        }
        tableViewer.getTable().setSortColumn(tableViewer.getTable().getColumn(column));
    }

    class HistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        HistoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ILogEntry entry = HistoryTableProvider.this.adaptToLogEntry(element);
            if (entry == null) {
                return "";
            }
            int index = columnIndex;
            if (columnIndex > 0 && !HistoryTableProvider.this.includeMergeRevisions) {
                ++index;
            }
            if (index > 1 && !HistoryTableProvider.this.includeTags) {
                ++index;
            }
            switch (index) {
                case 0: {
                    String revision = entry.getRevision().toString();
                    if (HistoryTableProvider.this.currentRemoteResource != null && entry.getRevision().equals((Object)HistoryTableProvider.this.currentRemoteResource.getLastChangedRevision())) {
                        revision = Policy.bind("currentRevision", revision);
                    }
                    return revision;
                }
                case 1: {
                    return entry.getMergedRevisionsAsString();
                }
                case 2: {
                    return AliasManager.getAliasesAsString((Alias[])entry.getTags());
                }
                case 3: {
                    Date date = entry.getDate();
                    if (date == null) {
                        return Policy.bind("notAvailable");
                    }
                    return DateFormat.getInstance().format(date);
                }
                case 4: {
                    if (entry.getAuthor() == null) {
                        return Policy.bind("noauthor");
                    }
                    return entry.getAuthor();
                }
                case 5: {
                    String comment = entry.getComment();
                    if (comment == null) {
                        return "";
                    }
                    return comment.replaceAll("\r", " ").replaceAll("\n", " ");
                }
                case 6: {
                    return HistoryTableProvider.this.getBugstringFromComment(entry.getComment());
                }
            }
            return "";
        }

        public Font getFont(Object element) {
            ILogEntry entry = HistoryTableProvider.this.adaptToLogEntry(element);
            if (entry == null) {
                return null;
            }
            SVNRevision.Number revision = entry.getRevision();
            SVNRevision.Number currentRevision = HistoryTableProvider.this.getCurrentRevision();
            if (currentRevision != null && currentRevision.equals((Object)revision)) {
                if (HistoryTableProvider.this.currentRevisionFont == null) {
                    Font defaultFont = JFaceResources.getDefaultFont();
                    FontData[] data = defaultFont.getFontData();
                    int i = 0;
                    while (i < data.length) {
                        data[i].setStyle(1);
                        ++i;
                    }
                    HistoryTableProvider.this.currentRevisionFont = new Font((Device)HistoryTableProvider.this.viewer.getTable().getDisplay(), data);
                }
                return HistoryTableProvider.this.currentRevisionFont;
            }
            return null;
        }
    }

    class HistorySorter
    extends ViewerSorter {
        private boolean reversed = false;
        private int columnNumber;
        private int[][] SORT_ORDERS_BY_COLUMN;

        public HistorySorter(int columnNumber) {
            int[][] nArrayArray = new int[7][];
            int[] nArray = new int[6];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[6];
            nArray2[0] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 4;
            nArray2[5] = 5;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[6];
            nArray3[0] = 2;
            nArray3[2] = 1;
            nArray3[3] = 3;
            nArray3[4] = 4;
            nArray3[5] = 5;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[6];
            nArray4[0] = 3;
            nArray4[2] = 1;
            nArray4[3] = 2;
            nArray4[4] = 4;
            nArray4[5] = 5;
            nArrayArray[3] = nArray4;
            int[] nArray5 = new int[6];
            nArray5[0] = 4;
            nArray5[2] = 1;
            nArray5[3] = 2;
            nArray5[4] = 3;
            nArray5[5] = 5;
            nArrayArray[4] = nArray5;
            int[] nArray6 = new int[6];
            nArray6[0] = 5;
            nArray6[2] = 1;
            nArray6[3] = 2;
            nArray6[4] = 3;
            nArray6[5] = 4;
            nArrayArray[5] = nArray6;
            int[] nArray7 = new int[6];
            nArray7[0] = 6;
            nArray7[2] = 1;
            nArray7[3] = 2;
            nArray7[4] = 3;
            nArray7[5] = 5;
            nArrayArray[6] = nArray7;
            this.SORT_ORDERS_BY_COLUMN = nArrayArray;
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            ILogEntry e1 = HistoryTableProvider.this.adaptToLogEntry(o1);
            ILogEntry e2 = HistoryTableProvider.this.adaptToLogEntry(o2);
            int result = 0;
            if (e1 == null || e2 == null) {
                result = super.compare(viewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], e1, e2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, ILogEntry e1, ILogEntry e2) {
            int column = columnNumber;
            if (column > 0 && !HistoryTableProvider.this.includeMergeRevisions) {
                ++column;
            }
            if (column > 1 && !HistoryTableProvider.this.includeTags) {
                ++column;
            }
            switch (column) {
                case 0: {
                    return e2.getRevision().getNumber() < e1.getRevision().getNumber() ? -1 : (e2.getRevision() == e1.getRevision() ? 0 : 1);
                }
                case 1: {
                    return e1.getMergedRevisionsAsString().compareTo(e2.getMergedRevisionsAsString());
                }
                case 2: {
                    String tags1 = AliasManager.getAliasesAsString((Alias[])e1.getTags());
                    String tags2 = AliasManager.getAliasesAsString((Alias[])e2.getTags());
                    return tags1.compareTo(tags2);
                }
                case 3: {
                    Date date1 = e1.getDate();
                    Date date2 = e2.getDate();
                    return date1.compareTo(date2);
                }
                case 4: {
                    return e1.getAuthor().compareTo(e2.getAuthor());
                }
                case 5: {
                    return e1.getComment().compareTo(e2.getComment());
                }
                case 6: {
                    if (HistoryTableProvider.this.projectProperties == null) break;
                    return HistoryTableProvider.this.getBugstringFromComment(e1.getComment()).compareTo(HistoryTableProvider.this.getBugstringFromComment(e2.getComment()));
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }
}

