/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNTreeConflict;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.ResolveAction;
import org.tigris.subversion.subclipse.ui.conflicts.ResolveTreeConflictWizard;
import org.tigris.subversion.subclipse.ui.wizards.SizePersistedWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizard;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardDialog;
import org.tigris.subversion.subclipse.ui.wizards.dialogs.SvnWizardMarkResolvedPage;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;

public class ResolveActionWithChoices
extends ResolveAction {
    private int selectedResolution;
    private SVNTreeConflict treeConflict;

    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        boolean propertyConflicts = false;
        boolean textConflicts = false;
        boolean treeConflicts = false;
        boolean treeConflictDialogShown = false;
        IResource[] resources = this.getSelectedResources();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IContainer) {
                // empty if block
            }
            if (!(propertyConflicts && textConflicts && treeConflicts)) {
                ISVNLocalResource resource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
                try {
                    LocalResourceStatus status = resource.getStatus();
                    if (status != null && status.isPropConflicted()) {
                        propertyConflicts = true;
                    }
                    if (status != null && status.isTextConflicted()) {
                        textConflicts = true;
                    }
                    if (status != null && status.hasTreeConflict()) {
                        treeConflicts = true;
                    }
                }
                catch (SVNException e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
            }
            ++i;
        }
        if (resources.length == 1 && treeConflicts && !propertyConflicts && !textConflicts) {
            this.treeConflict = this.getTreeConflict(resources[0]);
            if (this.treeConflict != null) {
                ResolveTreeConflictWizard wizard = new ResolveTreeConflictWizard(this.treeConflict, this.getTargetPart());
                SizePersistedWizardDialog dialog = new SizePersistedWizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard, "ResolveTreeConflict");
                if (dialog.open() != 0) {
                    return;
                }
                treeConflictDialogShown = true;
            }
        }
        if (resources.length > 1 && treeConflicts) {
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)Policy.bind("ResolveOperation.taskName"), (String)Policy.bind("ResolveAction.confirmTreeConflicts"))) {
                return;
            }
            this.setResolution(6);
        } else if (!treeConflictDialogShown) {
            SvnWizardMarkResolvedPage markResolvedPage = new SvnWizardMarkResolvedPage(resources);
            markResolvedPage.setPropertyConflicts(propertyConflicts);
            markResolvedPage.setTreeConflicts(treeConflicts);
            SvnWizard wizard = new SvnWizard(markResolvedPage);
            SvnWizardDialog dialog = new SvnWizardDialog(this.getShell(), (IWizard)wizard);
            wizard.setParentDialog((Dialog)dialog);
            if (dialog.open() == 1) {
                return;
            }
            this.setResolution(markResolvedPage.getResolution());
        }
        if (!treeConflictDialogShown) {
            super.execute(action);
        }
    }

    private SVNTreeConflict getTreeConflict(final IResource resource) {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            public void run() {
                ISVNClientAdapter client = null;
                try {
                    try {
                        client = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).getRepository().getSVNClient();
                        ISVNStatus[] statuses = client.getStatus(resource.getLocation().toFile(), true, true, true);
                        int i = 0;
                        while (i < statuses.length) {
                            if (statuses[i].hasTreeConflict()) {
                                ResolveActionWithChoices.this.treeConflict = new SVNTreeConflict(statuses[i]);
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        SVNUIPlugin.log(4, e.getMessage(), e);
                    }
                }
                finally {
                    SVNWorkspaceRoot.getSVNResourceFor((IResource)resource).getRepository().returnSVNClient(client);
                }
            }
        });
        return this.treeConflict;
    }
}

