/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.StructuredActivity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractTextCommand;

public class SplitTransitionCommand
extends AbstractTextCommand {
    private StructuredActivity parent;
    private Activity oldSource;
    private Activity oldTarget;
    private Transition transition;
    private Activity newActivity;

    public SplitTransitionCommand(ITextEditor textEditor) {
        super(textEditor);
    }

    public boolean canExecute() {
        return false;
    }

    public void execute() {
        this.oldSource.removeOutgoing(this.transition);
        this.oldTarget.removeIncoming(this.transition);
        this.parent.addChild(this.newActivity);
        new Transition(this.oldSource, this.newActivity);
        new Transition(this.newActivity, this.oldTarget);
    }

    public void setNewActivity(Activity activity) {
        this.newActivity = activity;
    }

    public void setParent(StructuredActivity activity) {
        this.parent = activity;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
        this.oldSource = transition.source;
        this.oldTarget = transition.target;
    }
}

