/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.figures.ConstructorArgumentFigure;
import org.springframework.ide.eclipse.beans.ui.graph.figures.PropertiesFigure;
import org.springframework.ide.eclipse.beans.ui.graph.figures.ShadowedLineBorder;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.model.ConstructorArgument;
import org.springframework.ide.eclipse.beans.ui.graph.model.Property;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;

public class BeanFigure
extends Figure {
    public static final Color COLOR = new Color(null, 255, 255, 206);
    public static final int MAX_NAME_LENGTH = 20;
    protected Bean bean;
    private IFigure contents;
    private Label label;
    private ConstructorArgumentFigure constructorArgumentFigure;
    private PropertiesFigure propertiesFigure;

    public BeanFigure(Bean bean) {
        this.bean = bean;
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new ShadowedLineBorder(ColorConstants.black, 1, 4));
        this.setOpaque(true);
        this.contents = new Figure();
        this.label = this.createLabel(bean);
        this.add((IFigure)this.label);
        if (bean.hasConstructorArguments()) {
            this.constructorArgumentFigure = this.createConstructorArguments(bean);
            this.add((IFigure)this.constructorArgumentFigure);
        }
        if (bean.hasProperties()) {
            this.propertiesFigure = this.createProperties(bean);
            this.add((IFigure)this.propertiesFigure);
        }
        if (bean.getInnerBeans().length > 0) {
            this.createInnerBeans(bean);
        }
        this.add(this.contents);
    }

    protected void createInnerBeans(Bean bean) {
        this.contents.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.contents.setBorder((Border)new MarginBorder(new Insets(8, 11, 8, 8)));
        Bean[] beanArray = bean.getInnerBeans();
        int n = beanArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bean innerBean = beanArray[n2];
            this.contents.add((IFigure)new BeanFigure(innerBean));
            ++n2;
        }
    }

    protected Label createLabel(Bean bean) {
        Label label = new Label();
        if (bean.getBean() != null && bean.getBean().getElementSourceLocation() instanceof XmlSourceLocation) {
            XmlSourceLocation location = (XmlSourceLocation)bean.getBean().getElementSourceLocation();
            StringBuilder text = new StringBuilder();
            if (location != null) {
                if (location.getPrefix() != null) {
                    text.append(location.getPrefix()).append(":").append(location.getLocalName()).append(" ");
                } else if (!"http://www.springframework.org/schema/beans".equals(location.getNamespaceURI())) {
                    text.append(location.getLocalName()).append(" ");
                }
            }
            text.append(bean.getName());
            label.setText(text.toString());
        } else {
            label.setText(bean.getName());
        }
        if (bean.isRootBean()) {
            label.setIcon(BeansUIPlugin.getLabelProvider().getImage((Object)bean.getBean()));
            if (bean.getClassName() != null) {
                label.setToolTip((IFigure)new Label("Class: " + bean.getClassName()));
            } else {
                label.setToolTip((IFigure)new Label("Class: <no class specified>"));
            }
        } else if (bean.isChildBean()) {
            label.setIcon(BeansUIPlugin.getLabelProvider().getImage((Object)bean.getBean()));
            label.setToolTip((IFigure)new Label("Parent: " + bean.getParentName()));
        }
        return label;
    }

    protected ConstructorArgumentFigure createConstructorArguments(Bean bean) {
        ConstructorArgument[] cargs = bean.getConstructorArguments();
        ConstructorArgumentFigure figure = new ConstructorArgumentFigure();
        ConstructorArgument[] constructorArgumentArray = cargs;
        int n = cargs.length;
        int n2 = 0;
        while (n2 < n) {
            ConstructorArgument carg = constructorArgumentArray[n2];
            String name = carg.getName();
            Label label = new Label();
            label.setText(name);
            Object value = carg.getBeanConstructorArgument().getValue();
            label.setToolTip((IFigure)new Label(this.createToolTipForValue(value)));
            label.setIcon(BeansUIPlugin.getLabelProvider().getImage((Object)carg.getBeanConstructorArgument()));
            figure.add((IFigure)label);
            ++n2;
        }
        return figure;
    }

    protected PropertiesFigure createProperties(Bean bean) {
        Property[] props = bean.getProperties();
        PropertiesFigure properties = new PropertiesFigure();
        Property[] propertyArray = props;
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            Property prop = propertyArray[n2];
            Label label = new Label(prop.getName());
            label.setIcon(BeansUIPlugin.getLabelProvider().getImage((Object)prop.getBeanProperty()));
            Object value = prop.getBeanProperty().getValue();
            label.setToolTip((IFigure)new Label(this.createToolTipForValue(value)));
            properties.add((IFigure)label);
            ++n2;
        }
        return properties;
    }

    private String createToolTipForValue(Object value) {
        StringBuffer toolTip = new StringBuffer("Value: ");
        if (value == null) {
            toolTip.append("NULL");
        } else if (value instanceof RuntimeBeanReference) {
            toolTip.append('<');
            toolTip.append(((RuntimeBeanReference)value).getBeanName());
            toolTip.append('>');
        } else if (value instanceof BeanDefinitionHolder) {
            toolTip.append('{');
            toolTip.append(((BeanDefinitionHolder)value).getBeanName());
            toolTip.append('}');
        } else {
            toolTip.append(value.toString());
        }
        return toolTip.toString();
    }

    public String toString() {
        Rectangle rect = this.getBounds();
        return "BeanFigure '" + this.bean.getName() + "': x=" + rect.x + ", y=" + rect.y + ", width=" + rect.width + ", height=" + rect.height;
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle r = super.getBounds();
        g.setAntialias(1);
        g.setBackgroundColor(COLOR);
        g.fillRectangle(r.x, r.y, 5, r.height - 5);
        g.fillRectangle(r.right() - 9, r.y, 5, r.height - 5);
        g.fillRectangle(r.x, r.bottom() - 9, r.width - 5, 5);
        g.fillRectangle(r.x, r.y, r.width - 5, this.getBeanSize());
    }

    public int getBeanSize() {
        int size = this.label.getPreferredSize().height;
        if (this.constructorArgumentFigure != null) {
            size += this.constructorArgumentFigure.getPreferredSize().height;
        }
        if (this.propertiesFigure != null) {
            size += this.propertiesFigure.getPreferredSize().height;
        }
        return size + 1;
    }

    public IFigure getContents() {
        return this.contents;
    }
}

