/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;
import org.springsource.ide.eclipse.commons.ui.launch.LaunchList;

public abstract class AbstractLaunchHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window;
        LaunchList.Item l = this.getLaunchItem();
        IWorkbenchWindow iWorkbenchWindow = window = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow() : null;
        if (l != null) {
            try {
                this.performOperation(l);
            }
            catch (DebugException e) {
                CorePlugin.log((Throwable)e);
                if (window != null) {
                    MessageDialog.openError((Shell)window.getShell(), (String)"Error relaunching", (String)ExceptionUtil.getMessage((Throwable)e));
                }
            }
        } else if (window != null) {
            MessageDialog.openError((Shell)window.getShell(), (String)"No Processes Found", (String)("Couldn't " + this.getOperationName() + ": no active processes"));
        }
        return null;
    }

    protected abstract LaunchList.Item getLaunchItem();

    protected abstract void performOperation(LaunchList.Item var1) throws DebugException;

    protected abstract String getOperationName();
}

