/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.mylyn.ui;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.springframework.ide.eclipse.beans.mylyn.core.BeansContextStructureBridge;
import org.springframework.ide.eclipse.beans.mylyn.ui.BeansActiveFoldingListener;
import org.springframework.ide.eclipse.beans.mylyn.ui.IBeansXmlEditor;

public class BeansActiveFoldingEditorTracker
extends AbstractEditorTracker {
    protected Map<IEditorPart, BeansActiveFoldingListener> editorListenerMap = new ConcurrentHashMap<IEditorPart, BeansActiveFoldingListener>();

    public void editorOpened(IEditorPart part) {
        if (part instanceof XMLMultiPageEditorPart || part instanceof IBeansXmlEditor) {
            this.registerEditor(part);
        }
    }

    public void editorClosed(IEditorPart part) {
        if (part instanceof XMLMultiPageEditorPart || part instanceof IBeansXmlEditor) {
            this.unregisterEditor(part);
        }
    }

    public void registerEditor(IEditorPart editor) {
        if (this.editorShouldBeRegistered(editor)) {
            if (this.editorListenerMap.containsKey(editor)) {
                return;
            }
            BeansActiveFoldingListener listener = new BeansActiveFoldingListener(editor);
            this.editorListenerMap.put(editor, listener);
        }
    }

    protected boolean editorShouldBeRegistered(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput != null && editorInput instanceof IFileEditorInput) {
            IFile resource = ((IFileEditorInput)editorInput).getFile();
            return BeansContextStructureBridge.isBeansConfig(resource);
        }
        return false;
    }

    public void unregisterEditor(IEditorPart editor) {
        BeansActiveFoldingListener listener = this.editorListenerMap.get(editor);
        if (listener != null) {
            listener.dispose();
        }
        this.editorListenerMap.remove(editor);
    }

    protected void editorBroughtToTop(IEditorPart part) {
    }
}

