/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg;

import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.cfg.BambooServerCfg;
import com.atlassian.theplugin.commons.cfg.CrucibleServerCfg;
import com.atlassian.theplugin.commons.cfg.FishEyeServer;
import com.atlassian.theplugin.commons.cfg.FishEyeServerCfg;
import com.atlassian.theplugin.commons.cfg.JiraServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerId;
import com.atlassian.theplugin.commons.cfg.ServerIdImpl;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectConfiguration {
    private Collection<ServerCfg> servers;
    private ServerIdImpl defaultCrucibleServerId;
    private String defaultCrucibleProject;
    private String defaultCrucibleRepo;
    private ServerIdImpl defaultFishEyeServerId;
    private String defaultFishEyeRepo;
    private String fishEyeProjectPath;
    private ServerIdImpl defaultJiraServerId;
    private static final int HASHCODE_MAGIC = 31;

    public ProjectConfiguration(ProjectConfiguration other) {
        this.servers = ProjectConfiguration.cloneArrayList(other.getServers());
        this.defaultCrucibleServerId = other.defaultCrucibleServerId;
        this.defaultFishEyeServerId = other.defaultFishEyeServerId;
        this.defaultCrucibleProject = other.defaultCrucibleProject;
        this.defaultCrucibleRepo = other.defaultCrucibleRepo;
        this.defaultFishEyeRepo = other.defaultFishEyeRepo;
        this.fishEyeProjectPath = other.fishEyeProjectPath;
        this.defaultJiraServerId = other.defaultJiraServerId;
    }

    public static Collection<ServerCfg> cloneArrayList(Collection<ServerCfg> collection) {
        ArrayList<ServerCfg> res = new ArrayList<ServerCfg>(collection.size());
        for (ServerCfg serverCfg : collection) {
            res.add(serverCfg.getClone());
        }
        return res;
    }

    public ProjectConfiguration(Collection<ServerCfg> servers) {
        if (servers == null) {
            throw new NullPointerException("Servers cannot be null");
        }
        this.servers = servers;
    }

    public ProjectConfiguration() {
        this.servers = MiscUtil.buildArrayList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectConfiguration)) {
            return false;
        }
        ProjectConfiguration that = (ProjectConfiguration)o;
        if (this.defaultCrucibleProject != null ? !this.defaultCrucibleProject.equals(that.defaultCrucibleProject) : that.defaultCrucibleProject != null) {
            return false;
        }
        if (this.defaultCrucibleServerId != null ? !this.defaultCrucibleServerId.equals(that.defaultCrucibleServerId) : that.defaultCrucibleServerId != null) {
            return false;
        }
        if (this.defaultCrucibleRepo != null ? !this.defaultCrucibleRepo.equals(that.defaultCrucibleRepo) : that.defaultCrucibleRepo != null) {
            return false;
        }
        if (this.defaultFishEyeServerId != null ? !this.defaultFishEyeServerId.equals(that.defaultFishEyeServerId) : that.defaultFishEyeServerId != null) {
            return false;
        }
        if (this.defaultFishEyeRepo != null ? !this.defaultFishEyeRepo.equals(that.defaultFishEyeRepo) : that.defaultFishEyeRepo != null) {
            return false;
        }
        if (this.fishEyeProjectPath != null ? !this.fishEyeProjectPath.equals(that.fishEyeProjectPath) : that.fishEyeProjectPath != null) {
            return false;
        }
        if (this.defaultJiraServerId != null ? !this.defaultJiraServerId.equals(that.defaultJiraServerId) : that.defaultJiraServerId != null) {
            return false;
        }
        return this.servers.equals(that.servers);
    }

    public int hashCode() {
        int result = this.servers.hashCode();
        result = 31 * result + (this.defaultCrucibleServerId != null ? this.defaultCrucibleServerId.hashCode() : 0);
        result = 31 * result + (this.defaultFishEyeServerId != null ? this.defaultFishEyeServerId.hashCode() : 0);
        result = 31 * result + (this.defaultCrucibleProject != null ? this.defaultCrucibleProject.hashCode() : 0);
        result = 31 * result + (this.defaultCrucibleRepo != null ? this.defaultCrucibleRepo.hashCode() : 0);
        result = 31 * result + (this.fishEyeProjectPath != null ? this.fishEyeProjectPath.hashCode() : 0);
        result = 31 * result + (this.defaultJiraServerId != null ? this.defaultJiraServerId.hashCode() : 0);
        return result;
    }

    public Collection<ServerCfg> getServers() {
        return this.servers;
    }

    public ServerCfg getServerCfg(ServerId serverId) {
        for (ServerCfg serverCfg : this.servers) {
            if (!serverId.equals(serverCfg.getServerId())) continue;
            return serverCfg;
        }
        return null;
    }

    public static ProjectConfiguration emptyConfiguration() {
        return new ProjectConfiguration();
    }

    public ProjectConfiguration getClone() {
        return new ProjectConfiguration(this);
    }

    public ServerIdImpl getDefaultCrucibleServerId() {
        CrucibleServerCfg serverCfg;
        if (this.defaultCrucibleServerId == null && this.getAllCrucibleServers().size() == 1 && (serverCfg = this.getAllCrucibleServers().iterator().next()).isEnabled()) {
            this.defaultCrucibleServerId = serverCfg.getServerId();
        }
        return this.defaultCrucibleServerId;
    }

    public CrucibleServerCfg getDefaultCrucibleServer() {
        if (this.getDefaultCrucibleServerId() == null) {
            return null;
        }
        ServerCfg serverCfg = this.getServerCfg(this.getDefaultCrucibleServerId());
        CrucibleServerCfg crucible = (CrucibleServerCfg)serverCfg;
        if (crucible == null || !crucible.isEnabled()) {
            return null;
        }
        return crucible;
    }

    public void setDefaultCrucibleServerId(ServerIdImpl defaultCrucibleServerId) {
        this.defaultCrucibleServerId = defaultCrucibleServerId;
        if (defaultCrucibleServerId == null) {
            this.setDefaultCrucibleProject(null);
            this.setDefaultCrucibleRepo(null);
        }
    }

    public ServerIdImpl getDefaultFishEyeServerId() {
        FishEyeServerCfg cfg;
        if (this.defaultFishEyeServerId == null && this.getAllFisheyeServers().size() == 1 && (cfg = this.getAllFisheyeServers().iterator().next()).isEnabled()) {
            this.defaultFishEyeServerId = cfg.getServerId();
        }
        return this.defaultFishEyeServerId;
    }

    public FishEyeServer getDefaultFishEyeServer() {
        if (this.getDefaultFishEyeServerId() == null) {
            return null;
        }
        ServerCfg serverCfg = this.getServerCfg(this.getDefaultFishEyeServerId());
        if (serverCfg == null || !serverCfg.isEnabled()) {
            return null;
        }
        FishEyeServer res = serverCfg.asFishEyeServer();
        if (res == null || !res.isEnabled()) {
            return null;
        }
        return res;
    }

    public void setDefaultFishEyeServerId(ServerIdImpl defaultFishEyeServerId) {
        this.defaultFishEyeServerId = defaultFishEyeServerId;
        if (defaultFishEyeServerId == null) {
            this.defaultFishEyeRepo = null;
        }
    }

    public ServerId getDefaultJiraServerId() {
        JiraServerCfg jiraServerCfg;
        if (this.defaultJiraServerId == null && this.getAllJIRAServers().size() == 1 && (jiraServerCfg = this.getAllJIRAServers().iterator().next()).isEnabled()) {
            this.defaultJiraServerId = jiraServerCfg.getServerId();
        }
        return this.defaultJiraServerId;
    }

    public JiraServerCfg getDefaultJiraServer() {
        if (this.getDefaultJiraServerId() == null) {
            return null;
        }
        ServerCfg serverCfg = this.getServerCfg(this.getDefaultJiraServerId());
        JiraServerCfg jiraServerCfg = (JiraServerCfg)serverCfg;
        if (jiraServerCfg == null || !jiraServerCfg.isEnabled()) {
            return null;
        }
        return jiraServerCfg;
    }

    public void setDefaultJiraServerId(ServerIdImpl defaultJiraServerId) {
        this.defaultJiraServerId = defaultJiraServerId;
    }

    public String getDefaultCrucibleProject() {
        return this.defaultCrucibleProject;
    }

    public void setDefaultCrucibleProject(String defaultCrucibleProject) {
        this.defaultCrucibleProject = defaultCrucibleProject;
    }

    public String getDefaultCrucibleRepo() {
        return this.defaultCrucibleRepo;
    }

    public void setDefaultCrucibleRepo(String defaultCrucibleRepo) {
        this.defaultCrucibleRepo = defaultCrucibleRepo;
    }

    public String getFishEyeProjectPath() {
        return this.fishEyeProjectPath;
    }

    public void setFishEyeProjectPath(String fishEyeProjectPath) {
        this.fishEyeProjectPath = fishEyeProjectPath;
    }

    public String getDefaultFishEyeRepo() {
        return this.defaultFishEyeRepo;
    }

    public void setDefaultFishEyeRepo(String defaultFishEyeRepo) {
        this.defaultFishEyeRepo = defaultFishEyeRepo;
    }

    public boolean isDefaultFishEyeServerValid() {
        if (this.getDefaultFishEyeServerId() == null) {
            return true;
        }
        ServerCfg serverCfg = this.getServerCfg(this.getDefaultFishEyeServerId());
        if (serverCfg == null) {
            return false;
        }
        FishEyeServer fishEye = serverCfg.asFishEyeServer();
        return fishEye != null && fishEye.isEnabled();
    }

    public boolean isDefaultCrucibleServerValid() {
        if (this.getDefaultCrucibleServerId() == null) {
            return true;
        }
        ServerCfg serverCfg = this.getServerCfg(this.getDefaultCrucibleServerId());
        CrucibleServerCfg crucible = (CrucibleServerCfg)serverCfg;
        return crucible != null && crucible.isEnabled();
    }

    public boolean isDefaultJiraServerValid() {
        if (this.getDefaultJiraServerId() == null) {
            return true;
        }
        ServerCfg serverCfg = this.getServerCfg(this.getDefaultJiraServerId());
        JiraServerCfg jiraServerCfg = (JiraServerCfg)serverCfg;
        return jiraServerCfg != null && jiraServerCfg.isEnabled();
    }

    public Collection<JiraServerCfg> getAllJIRAServers() {
        ArrayList<JiraServerCfg> jiraServers = MiscUtil.buildArrayList();
        for (ServerCfg server : this.servers) {
            if (server.getServerType() != ServerType.JIRA_SERVER || !(server instanceof JiraServerCfg)) continue;
            jiraServers.add((JiraServerCfg)server);
        }
        return jiraServers;
    }

    public Collection<BambooServerCfg> getAllBambooServers() {
        ArrayList<BambooServerCfg> bambooServers = MiscUtil.buildArrayList();
        for (ServerCfg server : this.servers) {
            if (server.getServerType() != ServerType.BAMBOO_SERVER || !(server instanceof BambooServerCfg)) continue;
            bambooServers.add((BambooServerCfg)server);
        }
        return bambooServers;
    }

    public Collection<CrucibleServerCfg> getAllCrucibleServers() {
        ArrayList<CrucibleServerCfg> crucibleServers = MiscUtil.buildArrayList();
        for (ServerCfg server : this.servers) {
            if (server.getServerType() != ServerType.CRUCIBLE_SERVER || !(server instanceof CrucibleServerCfg)) continue;
            crucibleServers.add((CrucibleServerCfg)server);
        }
        return crucibleServers;
    }

    public Collection<FishEyeServerCfg> getAllFisheyeServers() {
        ArrayList<FishEyeServerCfg> fisheyeServers = MiscUtil.buildArrayList();
        for (ServerCfg server : this.servers) {
            if (server.getServerType() != ServerType.FISHEYE_SERVER || !(server instanceof FishEyeServerCfg)) continue;
            fisheyeServers.add((FishEyeServerCfg)server);
        }
        return fisheyeServers;
    }

    public Collection<ServerCfg> getAllEnabledServersWithDefaultCredentials() {
        ArrayList<ServerCfg> defServers = MiscUtil.buildArrayList();
        for (ServerCfg server : this.servers) {
            if (!server.isUseDefaultCredentials() || !server.isEnabled()) continue;
            defServers.add(server);
        }
        return defServers;
    }
}

