/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.bamboo.api;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.BambooFileInfo;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooBuildInfo;
import com.atlassian.theplugin.commons.bamboo.BambooChangeSet;
import com.atlassian.theplugin.commons.bamboo.BambooChangeSetImpl;
import com.atlassian.theplugin.commons.bamboo.BambooJobImpl;
import com.atlassian.theplugin.commons.bamboo.BambooPlan;
import com.atlassian.theplugin.commons.bamboo.BambooProject;
import com.atlassian.theplugin.commons.bamboo.BambooProjectInfo;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.BuildDetailsInfo;
import com.atlassian.theplugin.commons.bamboo.BuildIssue;
import com.atlassian.theplugin.commons.bamboo.BuildIssueInfo;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import com.atlassian.theplugin.commons.bamboo.TestDetailsInfo;
import com.atlassian.theplugin.commons.bamboo.TestResult;
import com.atlassian.theplugin.commons.bamboo.api.BambooSession;
import com.atlassian.theplugin.commons.bamboo.api.LoginBambooSession;
import com.atlassian.theplugin.commons.cfg.SubscribedPlan;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiBadServerVersionException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import com.atlassian.theplugin.commons.util.Logger;
import com.atlassian.theplugin.commons.util.LoggerImpl;
import com.atlassian.theplugin.commons.util.MiscUtil;
import com.atlassian.theplugin.commons.util.UrlUtil;
import com.atlassian.theplugin.commons.util.XmlUtil;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooSessionImpl
extends LoginBambooSession
implements BambooSession {
    private final Logger loger;
    private static final String LIST_PROJECT_ACTION = "/api/rest/listProjectNames.action";
    private static final String LIST_PLAN_ACTION = "/api/rest/listBuildNames.action";
    private static final String LATEST_BUILD_FOR_PLAN_ACTION = "/api/rest/getLatestBuildResults.action";
    private static final String LATEST_BUILD_FOR_PLAN = "/rest/api/latest/result/";
    private static final String PLAN_STATE = "/rest/api/latest/plan/";
    private static final String GET_BUILD_ACTION = "/rest/api/latest/build/";
    private static final String GET_BUILD_DETAILS = "/rest/api/latest/result/";
    private static final String GET_ISSUES_SUFFIX = "?expand=jiraIssues";
    private static final String BUILD_QUEUE_SERVICE = "/rest/api/latest/queue/";
    private static final String RECENT_BUILDS_FOR_PLAN_ACTION = "/api/rest/getRecentlyCompletedBuildResultsForBuild.action";
    private static final String RECENT_BUILDS_FOR_USER_ACTION = "/api/rest/getLatestBuildsByUser.action";
    private static final String LATEST_USER_BUILDS_ACTION = "/api/rest/getLatestUserBuilds.action";
    private static final String GET_BUILD_DETAILS_ACTION = "/api/rest/getBuildResultsDetails.action";
    private static final String ADD_LABEL_ACTION = "/api/rest/addLabelToBuildResults.action";
    private static final String ADD_COMMENT_ACTION = "/api/rest/addCommentToBuildResults.action";
    private static final String EXECUTE_BUILD_ACTION = "/api/rest/executeBuild.action";
    private static final String GET_BAMBOO_BUILD_NUMBER_ACTION = "/api/rest/getBambooBuildNumber.action";
    private static final String GET_BUILD_BY_NUMBER_ACTION = "/rest/api/latest/build";
    private static final String BUILD_NUMBER_INFO = "/rest/api/latest/info";
    private static final String LIST_PLANS = "/rest/api/latest/plan?expand=plans&max-results=5000";
    private static final String BUILD_COMPLETED_DATE_ELEM = "buildCompletedDate";
    private static final String BUILD_SUCCESSFUL = "Successful";
    private static final String BUILD_FAILED = "Failed";
    private final ConnectionCfg serverData;
    private static final int BAMBOO_23_BUILD_NUMBER = 1308;
    private static final int BAMBOO_2_6_BUILD_NUMBER = 1839;
    private static final int BAMBOO_2_6_3_BUILD_NUMBER = 1904;
    private static final int BAMBOO_2_7_2_BUILD_NUMBER = 2101;
    private static final int BAMBOO_4_0_BUILD_NUMBER = 2906;
    private static final int BAMBOO_5_0_BUILD_NUMBER = 3600;
    private static final String CANNOT_PARSE_BUILD_TIME = "Cannot parse buildTime.";
    private static final String INVALID_SERVER_RESPONSE = "Invalid server response";
    private Integer serverBuildNumber;
    private static DateTimeFormatter buildDateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static DateTimeFormatter commitDateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ");
    private static DateTimeFormatter newApiDateFormat = ISODateTimeFormat.dateTime();

    public BambooSessionImpl(ConnectionCfg serverData, HttpSessionCallback callback, Logger logger) throws RemoteApiMalformedUrlException {
        super(serverData, callback);
        this.serverData = serverData;
        this.loger = logger;
    }

    private int getBamboBuildNumberImpl() throws RemoteApiException {
        Document doc;
        block5: {
            String queryUrl = String.valueOf(this.getBaseUrl()) + GET_BAMBOO_BUILD_NUMBER_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken);
            doc = this.retrieveGetResponse(queryUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception == null) break block5;
            return -1;
        }
        try {
            XPath xpath = XPath.newInstance((String)"/response/bambooBuildNumber");
            Element element = (Element)xpath.selectSingleNode((Object)doc);
            if (element != null) {
                String bNo = element.getText();
                return Integer.parseInt(bNo);
            }
            return -1;
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    private int getBamboBuildNumberImplNew() throws RemoteApiException {
        Document doc;
        block5: {
            String queryUrl = String.valueOf(this.getBaseUrl()) + BUILD_NUMBER_INFO + "?auth=" + UrlUtil.encodeUrl(this.authToken);
            doc = this.retrieveGetResponse(queryUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception == null) break block5;
            return -1;
        }
        try {
            XPath xpath = XPath.newInstance((String)"/info/buildNumber");
            Element element = (Element)xpath.selectSingleNode((Object)doc);
            if (element != null) {
                String bNo = element.getText();
                return Integer.parseInt(bNo);
            }
            return -1;
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    @Override
    @NotNull
    public List<BambooProject> listProjectNames() throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + LIST_PROJECT_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken);
        ArrayList<BambooProject> projects = new ArrayList<BambooProject>();
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            XPath xpath = XPath.newInstance((String)"/response/project");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null) {
                for (Element element : elements) {
                    String name = element.getChild("name").getText();
                    String key = element.getChild("key").getText();
                    projects.add(new BambooProjectInfo(name, key));
                }
            }
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
        return projects;
    }

    @NotNull
    private List<BambooPlan> listPlanNames() throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + LIST_PLAN_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken);
        ArrayList<BambooPlan> plans = new ArrayList<BambooPlan>();
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            XPath xpath = XPath.newInstance((String)"/response/build");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null) {
                for (Element element : elements) {
                    String enabledValue = element.getAttributeValue("enabled");
                    boolean enabled = true;
                    if (enabledValue != null) {
                        enabled = Boolean.parseBoolean(enabledValue);
                    }
                    String name = element.getChild("name").getText();
                    String key = element.getChild("key").getText();
                    BambooPlan plan = new BambooPlan(name, key, null, enabled);
                    plans.add(plan);
                }
            }
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
        return plans;
    }

    @NotNull
    private List<BambooPlan> listPlanNames_40() throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + LIST_PLANS;
        ArrayList<BambooPlan> plans = new ArrayList<BambooPlan>();
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            XPath xpath = XPath.newInstance((String)"/plans/plans/plan");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null) {
                for (Element element : elements) {
                    String enabledValue = element.getAttributeValue("enabled");
                    boolean enabled = true;
                    if (enabledValue != null) {
                        enabled = Boolean.parseBoolean(enabledValue);
                    }
                    String name = element.getAttributeValue("name");
                    String key = element.getAttributeValue("key");
                    BambooPlan plan = new BambooPlan(name, key, null, enabled);
                    plans.add(plan);
                }
            }
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
        return plans;
    }

    @Override
    @NotNull
    public BambooBuild getLatestBuildForPlan(@NotNull String planKey, int timezoneOffset) throws RemoteApiException {
        List<BambooPlan> planList = this.listPlanNames();
        Boolean isEnabled = BambooSessionImpl.isPlanEnabled(planList, planKey);
        return this.getLatestBuildForPlan(planKey, isEnabled != null ? isEnabled : true, timezoneOffset);
    }

    @Nullable
    public static Boolean isPlanEnabled(@NotNull Collection<BambooPlan> allPlans, @NotNull String planKey) {
        for (BambooPlan bambooPlan : allPlans) {
            if (!planKey.equals(bambooPlan.getKey())) continue;
            return bambooPlan.isEnabled();
        }
        return null;
    }

    @NotNull
    public BambooBuild getLatestBuildForPlan(@NotNull String planKey, boolean isPlanEnabled, int timezoneOffset) throws RemoteApiException {
        return this.getLatestBuildBuilderForPlan(planKey, timezoneOffset).enabled(isPlanEnabled).build();
    }

    @NotNull
    public BambooBuildInfo.Builder getLatestBuildBuilderForPlan(@NotNull String planKey, int timezoneOffset) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + LATEST_BUILD_FOR_PLAN_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken) + "&buildKey=" + UrlUtil.encodeUrl(planKey);
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                return this.constructBuildErrorInfo(planKey, exception, new Date());
            }
            List elements = XPath.newInstance((String)"/response").selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                Element e = (Element)elements.iterator().next();
                Set<String> commiters = this.constructBuildCommiters(e);
                return this.constructBuilderItem(e, new Date(), planKey, commiters, timezoneOffset);
            }
            return this.constructBuildErrorInfo(planKey, "Malformed server reply: no response element", new Date());
        }
        catch (IOException e) {
            return this.constructBuildErrorInfo(planKey, e.getMessage(), e, new Date());
        }
        catch (JDOMException e) {
            return this.constructBuildErrorInfo(planKey, "Server returned malformed response", e, new Date());
        }
        catch (RemoteApiException e) {
            return this.constructBuildErrorInfo(planKey, e.getMessage(), e, new Date());
        }
    }

    @NotNull
    public BambooBuildInfo.Builder getLatestBuildBuilderForPlan_40(@NotNull String planKey, int timezoneOffset) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + "/rest/api/latest/result/" + UrlUtil.encodeUrl(planKey) + "?expand=" + UrlUtil.encodeUrl("results[0].result");
        try {
            Element e;
            String size;
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                return this.constructBuildErrorInfo(planKey, exception, new Date());
            }
            List elements = XPath.newInstance((String)"/results/results/result").selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                Element e2 = (Element)elements.iterator().next();
                String buildNumber = e2.getAttributeValue("number");
                Set<String> commiters = this.getCommitersForBuild_40(planKey, buildNumber);
                return this.constructBuilderItem_40(e2, new Date(), planKey, commiters, timezoneOffset);
            }
            elements = XPath.newInstance((String)"/results/results").selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty() && (size = (e = (Element)elements.iterator().next()).getAttributeValue("size")) != null && size.length() > 0 && "0".equals(size)) {
                return new BambooBuildInfo.Builder(planKey, this.serverData, BuildStatus.UNKNOWN).pollingTime(new Date()).reason("Never built");
            }
            return this.constructBuildErrorInfo(planKey, "Malformed server reply: no response element", new Date());
        }
        catch (IOException e) {
            return this.constructBuildErrorInfo(planKey, e.getMessage(), e, new Date());
        }
        catch (JDOMException e) {
            return this.constructBuildErrorInfo(planKey, "Server returned malformed response", e, new Date());
        }
        catch (RemoteApiException e) {
            return this.constructBuildErrorInfo(planKey, e.getMessage(), e, new Date());
        }
    }

    public Set<String> getCommitersForBuild_40(@NotNull String planKey, @NotNull String buildNumber) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + "/rest/api/latest/result/" + UrlUtil.encodeUrl(planKey) + "/" + buildNumber + "?expand=changes";
        HashSet<String> commiters = new HashSet<String>();
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            List elements = XPath.newInstance((String)"/result/changes/change").selectNodes((Object)doc);
            if (!elements.isEmpty()) {
                for (Element commiter : elements) {
                    commiters.add(commiter.getAttributeValue("author"));
                }
            }
            return commiters;
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    @Override
    @NotNull
    public BambooPlan getPlanDetails(@NotNull String planKey) throws RemoteApiException {
        String planUrl = String.valueOf(this.getBaseUrl()) + PLAN_STATE + UrlUtil.encodeUrl(planKey);
        try {
            Document doc = this.retrieveGetResponse(planUrl);
            List elements = XPath.newInstance((String)"/plan").selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                Element e = (Element)elements.iterator().next();
                return this.constructPlanItem(e, Boolean.TRUE);
            }
            throw new RemoteApiException("Malformed server reply: no 'plan' element");
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    @Override
    @NotNull
    public BambooBuild getLatestBuildForPlanNew(@NotNull String planKey, @Nullable String masterPlanKey, boolean isPlanEnabled, int timezoneOffset) throws RemoteApiException {
        String planUrl = String.valueOf(this.getBaseUrl()) + PLAN_STATE + UrlUtil.encodeUrl(planKey);
        try {
            Document doc = this.retrieveGetResponse(planUrl);
            List elements = XPath.newInstance((String)"/plan").selectNodes((Object)doc);
            if (elements != null && !elements.isEmpty()) {
                Element e = (Element)elements.iterator().next();
                BambooPlan plan = this.constructPlanItem(e, isPlanEnabled);
                BambooBuildInfo.Builder latestBuildBuilderForPlan = this.getBamboBuildNumber() >= 2906 ? this.getLatestBuildBuilderForPlan_40(planKey, timezoneOffset) : this.getLatestBuildBuilderForPlan(planKey, timezoneOffset);
                latestBuildBuilderForPlan.planState(plan.getState());
                latestBuildBuilderForPlan.enabled(isPlanEnabled);
                latestBuildBuilderForPlan.masterPlanKey(masterPlanKey);
                return latestBuildBuilderForPlan.build();
            }
            return this.constructBuildErrorInfo(planKey, "Malformed server reply: no 'plan' element", new Date()).build();
        }
        catch (IOException e) {
            return this.constructBuildErrorInfo(planKey, e.getMessage(), e, new Date()).build();
        }
        catch (JDOMException e) {
            return this.constructBuildErrorInfo(planKey, "Server returned malformed response", e, new Date()).build();
        }
        catch (RemoteApiException e) {
            return this.constructBuildErrorInfo(planKey, e.getMessage(), e, new Date()).build();
        }
    }

    @Override
    @NotNull
    public BambooBuild getBuildForPlanAndNumber(@NotNull String planKey, int buildNumber, int timezoneOffset) throws RemoteApiException {
        String nodePath;
        String buildResultUrl;
        Collection<BambooBuild> recentBuilds = this.getRecentBuildsForPlan(planKey, timezoneOffset);
        try {
            for (BambooBuild recentBuild : recentBuilds) {
                if (recentBuild.getNumber() != buildNumber) continue;
                return recentBuild;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        int bambooBuild = this.getBamboBuildNumber();
        if (bambooBuild < 1308) {
            throw new RemoteApiBadServerVersionException("Bamboo version 2.3 or newer required");
        }
        if (bambooBuild < 1904) {
            buildResultUrl = String.valueOf(this.getBaseUrl()) + GET_BUILD_BY_NUMBER_ACTION + "/" + UrlUtil.encodeUrl(planKey) + "/" + buildNumber + "?auth=" + UrlUtil.encodeUrl(this.authToken);
            nodePath = "/build";
        } else {
            buildResultUrl = String.valueOf(this.getBaseUrl()) + "/rest/api/latest/result/" + UrlUtil.encodeUrl(planKey) + "-" + buildNumber;
            nodePath = "/result";
        }
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                return this.constructBuildErrorInfo(buildResultUrl, exception, new Date()).build();
            }
            List elements = XPath.newInstance((String)nodePath).selectNodes((Object)doc);
            Element el = (Element)elements.get(0);
            return this.constructBuildItemFromNewApi(el, new Date(), planKey);
        }
        catch (IOException e) {
            throw new RemoteApiException(e);
        }
        catch (JDOMException e) {
            throw new RemoteApiException(e);
        }
    }

    @Override
    public Collection<BambooBuild> getRecentBuildsForPlan(@NotNull String planKey, int timezoneOffset) throws RemoteApiException {
        if (this.getBamboBuildNumber() >= 2906) {
            return this.getBuildsCollection_40(planKey, timezoneOffset);
        }
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + RECENT_BUILDS_FOR_PLAN_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken) + "&buildKey=" + UrlUtil.encodeUrl(planKey);
        return this.getBuildsCollection(buildResultUrl, planKey, timezoneOffset);
    }

    @Override
    public Collection<BambooBuild> getRecentBuildsForUser(int timezoneOffset) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + RECENT_BUILDS_FOR_USER_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken) + "&username=" + UrlUtil.encodeUrl(this.getUsername());
        return this.getBuildsCollection(buildResultUrl, this.getUsername(), timezoneOffset);
    }

    private Collection<BambooBuild> getBuildsCollection(@NotNull String url, @NotNull String planKey, int timezoneOffset) throws RemoteApiException {
        Date pollingTime = new Date();
        ArrayList<BambooBuild> builds = new ArrayList<BambooBuild>();
        try {
            Document doc = this.retrieveGetResponse(url);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                builds.add(this.constructBuildErrorInfo(url, exception, new Date()).build());
                return builds;
            }
            List elements = XPath.newInstance((String)"/response/build").selectNodes((Object)doc);
            if (elements == null || elements.isEmpty()) {
                builds.add(this.constructBuildErrorInfo(url, "Malformed server reply: no response element", new Date()).build());
            } else {
                for (Element element : elements) {
                    Set<String> commiters = this.constructBuildCommiters(element);
                    builds.add(this.constructBuilderItem(element, pollingTime, planKey, commiters, timezoneOffset).enabled(true).build());
                }
            }
        }
        catch (IOException e) {
            builds.add(this.constructBuildErrorInfo(planKey, e.getMessage(), e, pollingTime).build());
        }
        catch (JDOMException e) {
            builds.add(this.constructBuildErrorInfo(planKey, "Server returned malformed response", e, pollingTime).build());
        }
        catch (RemoteApiException e) {
            builds.add(this.constructBuildErrorInfo(planKey, e.getMessage(), e, pollingTime).build());
        }
        return builds;
    }

    private Collection<BambooBuild> getBuildsCollection_40(@NotNull String planKey, int timezoneOffset) throws RemoteApiException {
        String url = String.valueOf(this.getBaseUrl()) + "/rest/api/latest/result/" + UrlUtil.encodeUrl(planKey) + "?expand=" + UrlUtil.encodeUrl("results[0:10].result");
        Date pollingTime = new Date();
        ArrayList<BambooBuild> builds = new ArrayList<BambooBuild>();
        try {
            Document doc = this.retrieveGetResponse(url);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                builds.add(this.constructBuildErrorInfo(url, exception, new Date()).build());
                return builds;
            }
            List elements = XPath.newInstance((String)"/results/results/result").selectNodes((Object)doc);
            if (elements == null || elements.isEmpty()) {
                builds.add(this.constructBuildErrorInfo(url, "Malformed server reply: no response element", new Date()).build());
            } else {
                for (Element element : elements) {
                    Set<String> commiters = this.constructBuildCommiters(element);
                    builds.add(this.constructBuilderItem_40(element, pollingTime, planKey, commiters, timezoneOffset).enabled(true).build());
                }
            }
        }
        catch (IOException e) {
            builds.add(this.constructBuildErrorInfo(planKey, e.getMessage(), e, pollingTime).build());
        }
        catch (JDOMException e) {
            builds.add(this.constructBuildErrorInfo(planKey, "Server returned malformed response", e, pollingTime).build());
        }
        catch (RemoteApiException e) {
            builds.add(this.constructBuildErrorInfo(planKey, e.getMessage(), e, pollingTime).build());
        }
        return builds;
    }

    private Set<String> constructBuildCommiters(Element element) throws JDOMException {
        HashSet<String> commiters = new HashSet<String>();
        List commitElements = XPath.newInstance((String)"commits/commit").selectNodes((Object)element);
        if (!commitElements.isEmpty()) {
            for (Element commiter : commitElements) {
                commiters.add(commiter.getAttributeValue("author"));
            }
        }
        return commiters;
    }

    @Override
    @NotNull
    public List<String> getFavouriteUserPlans() throws RemoteApiException {
        ArrayList<String> builds = new ArrayList<String>();
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + LATEST_USER_BUILDS_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken);
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                return builds;
            }
            XPath xpath = XPath.newInstance((String)"/response/build");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null) {
                for (Element element : elements) {
                    builds.add(element.getChildText("key"));
                }
                return builds;
            }
            return builds;
        }
        catch (IOException iOException) {
            return builds;
        }
        catch (JDOMException jDOMException) {
            return builds;
        }
    }

    @NotNull
    public List<String> getFavouriteUserPlansNew() throws RemoteApiException {
        ArrayList<String> builds = new ArrayList<String>();
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + PLAN_STATE + "?favourite&expand=plans";
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                return builds;
            }
            XPath xpath = XPath.newInstance((String)"/plans/plans/plan");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null) {
                for (Element element : elements) {
                    builds.add(element.getAttributeValue("key"));
                }
                return builds;
            }
            return builds;
        }
        catch (IOException iOException) {
            return builds;
        }
        catch (JDOMException jDOMException) {
            return builds;
        }
    }

    @NotNull
    private BuildDetails getBuildResultDetailsOld(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + GET_BUILD_DETAILS_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken) + "&buildKey=" + UrlUtil.encodeUrl(planKey) + "&buildNumber=" + buildNumber;
        try {
            BuildDetailsInfo build = new BuildDetailsInfo();
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiException(exception);
            }
            List responseElements = XPath.newInstance((String)"/response").selectNodes((Object)doc);
            for (Element element : responseElements) {
                String vcsRevisionKey = element.getAttributeValue("vcsRevisionKey");
                if (vcsRevisionKey == null) continue;
                build.setVcsRevisionKey(vcsRevisionKey);
            }
            List commitElements = XPath.newInstance((String)"/response/commits/commit").selectNodes((Object)doc);
            if (!commitElements.isEmpty()) {
                int i = 1;
                for (Element element : commitElements) {
                    BambooChangeSetImpl cInfo = new BambooChangeSetImpl();
                    cInfo.setAuthor(element.getAttributeValue("author"));
                    cInfo.setCommitDate(this.parseCommitTime(element.getAttributeValue("date")));
                    cInfo.setComment(this.getChildText(element, "comment"));
                    String path = "/response/commits/commit[" + i++ + "]/files/file";
                    XPath filesPath = XPath.newInstance((String)path);
                    List fileElements = filesPath.selectNodes((Object)doc);
                    for (Element file : fileElements) {
                        BambooFileInfo fileInfo = new BambooFileInfo(file.getAttributeValue("name"), file.getAttributeValue("revision"));
                        cInfo.addCommitFile(fileInfo);
                    }
                    build.addCommitInfo(cInfo);
                }
            }
            List sucTestResElements = XPath.newInstance((String)"/response/successfulTests/testResult").selectNodes((Object)doc);
            for (Element element : sucTestResElements) {
                double duration;
                TestDetailsInfo tInfo = new TestDetailsInfo();
                tInfo.setTestClassName(element.getAttributeValue("testClass"));
                tInfo.setTestMethodName(element.getAttributeValue("testMethod"));
                try {
                    duration = Double.valueOf(element.getAttributeValue("duration"));
                }
                catch (NumberFormatException numberFormatException) {
                    duration = 0.0;
                }
                tInfo.setTestDuration(duration);
                tInfo.setTestResult(TestResult.TEST_SUCCEED);
                build.addSuccessfulTest(tInfo);
            }
            List failedTestResElements = XPath.newInstance((String)"/response/failedTests/testResult").selectNodes((Object)doc);
            if (!failedTestResElements.isEmpty()) {
                int i = 1;
                for (Element element : failedTestResElements) {
                    double duration;
                    TestDetailsInfo tInfo = new TestDetailsInfo();
                    tInfo.setTestClassName(element.getAttributeValue("testClass"));
                    tInfo.setTestMethodName(element.getAttributeValue("testMethod"));
                    try {
                        duration = Double.valueOf(element.getAttributeValue("duration"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        duration = 0.0;
                    }
                    tInfo.setTestDuration(duration);
                    tInfo.setTestResult(TestResult.TEST_FAILED);
                    String path = "/response/failedTests/testResult[" + i++ + "]/errors/error";
                    XPath errorPath = XPath.newInstance((String)path);
                    List errorElements = errorPath.selectNodes((Object)doc);
                    for (Element error : errorElements) {
                        tInfo.setTestErrors(error.getText());
                    }
                    build.addFailedTest(tInfo);
                }
            }
            return build;
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    @Override
    public int getBamboBuildNumber() throws RemoteApiException {
        if (this.serverBuildNumber != null) {
            return this.serverBuildNumber;
        }
        try {
            this.serverBuildNumber = this.getBamboBuildNumberImpl();
        }
        catch (RemoteApiException remoteApiException) {
            this.loger.info("Old Bamboo API is not available. Server error or Bamboo 4.0+ detected.");
            this.serverBuildNumber = this.getBamboBuildNumberImplNew();
        }
        return this.serverBuildNumber;
    }

    @Override
    public BuildDetails getBuildResultDetails(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        int bamboBuildNumber = this.getBamboBuildNumber();
        if (bamboBuildNumber >= 1839 && bamboBuildNumber <= 1904) {
            return this.getBuildResultDetailsMoreRestish(planKey, buildNumber);
        }
        if (bamboBuildNumber > 1904 && bamboBuildNumber <= 2101) {
            return this.getBuildResultDetailsNew(planKey, buildNumber);
        }
        if (bamboBuildNumber > 2101) {
            return this.getBuildResultDetails3x(planKey, buildNumber);
        }
        return this.getBuildResultDetailsOld(planKey, buildNumber);
    }

    private BuildDetails getBuildResultDetails3x(String planKey, int buildNumber) throws RemoteApiException {
        List<BambooJobImpl> jobs = this.getJobsForPlan(planKey);
        BuildDetailsInfo build = new BuildDetailsInfo();
        for (BambooJobImpl job : jobs) {
            build.addJob(job);
            if (!job.isEnabled()) continue;
            String url = this.getBaseUrl() + "/rest/api/latest/result/" + job.getKey() + "-" + buildNumber + "?" + "expand=testResults.allTests.testResult.errors";
            try {
                Document doc = this.retrieveGetResponse(url);
                String exception = BambooSessionImpl.getExceptionMessages(doc);
                if (exception != null) {
                    throw new RemoteApiException(exception);
                }
                List testResElements = XPath.newInstance((String)"/result/testResults/allTests/testResult").selectNodes((Object)doc);
                for (Element element : testResElements) {
                    TestDetailsInfo tInfo = new TestDetailsInfo();
                    tInfo.setTestClassName(element.getAttributeValue("className"));
                    tInfo.setTestMethodName(element.getAttributeValue("methodName"));
                    try {
                        tInfo.setTestResult(this.parseTestResult(element.getAttributeValue("status")));
                    }
                    catch (ParseException e1) {
                        this.loger.warn("Cannot parse test result element:\n" + XmlUtil.toPrettyFormatedString(element), e1);
                        continue;
                    }
                    tInfo.setTestDuration(this.parseDuration(element.getChild("duration")));
                    StringBuilder errorBuilder = new StringBuilder();
                    XPath errorPath = XPath.newInstance((String)"errors/error");
                    List errorElements = errorPath.selectNodes((Object)element);
                    for (Element errorElement : errorElements) {
                        String errorEntry = errorElement.getChildText("message");
                        if (errorEntry == null) continue;
                        errorBuilder.append(errorEntry).append('\n');
                    }
                    tInfo.setTestErrors(errorBuilder.toString());
                    switch (tInfo.getTestResult()) {
                        case TEST_FAILED: {
                            build.addFailedTest(tInfo);
                            job.addFailedTest(tInfo);
                            break;
                        }
                        case TEST_SUCCEED: {
                            build.addSuccessfulTest(tInfo);
                            job.addSuccessfulTest(tInfo);
                            break;
                        }
                    }
                }
                Element changesElement = doc.getRootElement().getChild("changes");
                if (changesElement == null) continue;
                build.setCommitInfo(this.parseChangeSets(changesElement));
            }
            catch (JDOMException e) {
                throw new RemoteApiException("Server returned malformed response", e);
            }
            catch (IOException e) {
                throw new RemoteApiException(e.getMessage(), e);
            }
            catch (ParseException e) {
                throw new RemoteApiException("Server returned malformed response", e);
            }
        }
        return build;
    }

    @NotNull
    private BuildDetails getBuildResultDetailsNew(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        List<BambooJobImpl> jobs = this.getJobsForPlan(planKey);
        BuildDetailsInfo build = new BuildDetailsInfo();
        for (BambooJobImpl job : jobs) {
            build.addJob(job);
            if (!job.isEnabled()) continue;
            String url = this.getBaseUrl() + "/rest/api/latest/result/" + job.getKey() + "-" + buildNumber + "?" + "expand=testResults.all.testResult.errors";
            try {
                Document doc = this.retrieveGetResponse(url);
                String exception = BambooSessionImpl.getExceptionMessages(doc);
                if (exception != null) {
                    throw new RemoteApiException(exception);
                }
                List testResElements = XPath.newInstance((String)"/result/testResults/all/testResult").selectNodes((Object)doc);
                for (Element element : testResElements) {
                    TestDetailsInfo tInfo = new TestDetailsInfo();
                    tInfo.setTestClassName(element.getAttributeValue("className"));
                    tInfo.setTestMethodName(element.getAttributeValue("methodName"));
                    try {
                        tInfo.setTestResult(this.parseTestResult(element.getAttributeValue("status")));
                    }
                    catch (ParseException e1) {
                        this.loger.warn("Cannot parse test result element:\n" + XmlUtil.toPrettyFormatedString(element), e1);
                        continue;
                    }
                    tInfo.setTestDuration(this.parseDuration(element.getChild("duration")));
                    StringBuilder errorBuilder = new StringBuilder();
                    XPath errorPath = XPath.newInstance((String)"errors/error");
                    List errorElements = errorPath.selectNodes((Object)element);
                    for (Element errorElement : errorElements) {
                        String errorEntry = errorElement.getChildText("message");
                        if (errorEntry == null) continue;
                        errorBuilder.append(errorEntry).append('\n');
                    }
                    tInfo.setTestErrors(errorBuilder.toString());
                    switch (tInfo.getTestResult()) {
                        case TEST_FAILED: {
                            build.addFailedTest(tInfo);
                            job.addFailedTest(tInfo);
                            break;
                        }
                        case TEST_SUCCEED: {
                            build.addSuccessfulTest(tInfo);
                            job.addSuccessfulTest(tInfo);
                            break;
                        }
                    }
                }
                Element changesElement = doc.getRootElement().getChild("changes");
                if (changesElement == null) continue;
                build.setCommitInfo(this.parseChangeSets(changesElement));
            }
            catch (JDOMException e) {
                throw new RemoteApiException("Server returned malformed response", e);
            }
            catch (IOException e) {
                throw new RemoteApiException(e.getMessage(), e);
            }
            catch (ParseException e) {
                throw new RemoteApiException("Server returned malformed response", e);
            }
        }
        return build;
    }

    @NotNull
    BuildDetails getBuildResultDetailsMoreRestish(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + GET_BUILD_BY_NUMBER_ACTION + "/" + UrlUtil.encodeUrl(planKey) + "/" + buildNumber + "?auth=" + UrlUtil.encodeUrl(this.authToken) + "&expand=testResults.all.testResult.errors&expand=changes.change.files";
        try {
            BuildDetailsInfo build = new BuildDetailsInfo();
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiException(exception);
            }
            List testResElements = XPath.newInstance((String)"/build/testResults/all/testResult").selectNodes((Object)doc);
            for (Element element : testResElements) {
                TestDetailsInfo tInfo = new TestDetailsInfo();
                tInfo.setTestClassName(element.getAttributeValue("className"));
                tInfo.setTestMethodName(element.getAttributeValue("methodName"));
                try {
                    tInfo.setTestResult(this.parseTestResult(element.getAttributeValue("status")));
                }
                catch (ParseException e1) {
                    this.loger.warn("Cannot parse test result element:\n" + XmlUtil.toPrettyFormatedString(element), e1);
                    continue;
                }
                tInfo.setTestDuration(this.parseDuration(element.getChild("duration")));
                StringBuilder errorBuilder = new StringBuilder();
                XPath errorPath = XPath.newInstance((String)"errors/error");
                List errorElements = errorPath.selectNodes((Object)element);
                for (Element errorElement : errorElements) {
                    String errorEntry = errorElement.getChildText("message");
                    if (errorEntry == null) continue;
                    errorBuilder.append(errorEntry).append('\n');
                }
                tInfo.setTestErrors(errorBuilder.toString());
                switch (tInfo.getTestResult()) {
                    case TEST_FAILED: {
                        build.addFailedTest(tInfo);
                        break;
                    }
                    case TEST_SUCCEED: {
                        build.addSuccessfulTest(tInfo);
                        break;
                    }
                }
            }
            Element changesElement = doc.getRootElement().getChild("changes");
            if (changesElement != null) {
                build.setCommitInfo(this.parseChangeSets(changesElement));
            }
            return build;
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
    }

    List<BambooChangeSet> parseChangeSets(Element changesElement) throws RemoteApiException {
        ArrayList<BambooChangeSet> changeSets = MiscUtil.buildArrayList();
        List<Element> changeElements = XmlUtil.getChildElements(changesElement, "change");
        for (Element changeElement : changeElements) {
            BambooChangeSetImpl cInfo = new BambooChangeSetImpl();
            cInfo.setAuthor(changeElement.getAttributeValue("author"));
            String dateStr = changeElement.getChildText("date");
            if (dateStr == null) {
                throw new RemoteApiException("change element does not have mandatory date element");
            }
            cInfo.setCommitDate(this.parseNewApiBuildTime(dateStr));
            cInfo.setComment(this.getChildText(changeElement, "comment"));
            Element filesElement = changeElement.getChild("files");
            if (filesElement != null) {
                List<Element> fileElements = XmlUtil.getChildElements(filesElement, "file");
                for (Element fileElement : fileElements) {
                    BambooFileInfo fileInfo = new BambooFileInfo(this.getChildText(fileElement, "name").trim(), this.getChildText(fileElement, "revision").trim());
                    cInfo.addCommitFile(fileInfo);
                }
            }
            changeSets.add(cInfo);
        }
        return changeSets;
    }

    private double parseDuration(Element durationElement) throws ParseException {
        if (durationElement == null) {
            throw new ParseException("null duration element", 0);
        }
        String durationStr = durationElement.getText();
        try {
            return Double.valueOf(durationStr) / 1000.0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Cannot parse duration element as floating point number [" + durationStr + "]", 0);
        }
    }

    private TestResult parseTestResult(String attributeValue) throws ParseException {
        if ("failed".equals(attributeValue)) {
            return TestResult.TEST_FAILED;
        }
        if ("successful".equals(attributeValue)) {
            return TestResult.TEST_SUCCEED;
        }
        throw new ParseException("Invalid test result [" + attributeValue + "]", 0);
    }

    @Override
    public void addLabelToBuild(@NotNull String planKey, int buildNumber, String buildLabel) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + ADD_LABEL_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken) + "&buildKey=" + UrlUtil.encodeUrl(planKey) + "&buildNumber=" + buildNumber + "&label=" + UrlUtil.encodeUrl(buildLabel);
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiException(exception);
            }
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    @Override
    public void addCommentToBuild(@NotNull String planKey, int buildNumber, String buildComment) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + ADD_COMMENT_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken) + "&buildKey=" + UrlUtil.encodeUrl(planKey) + "&buildNumber=" + buildNumber + "&content=" + UrlUtil.encodeUrl(buildComment);
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiException(exception);
            }
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    @Override
    public void executeBuild(@NotNull String planKey) throws RemoteApiException {
        if (this.getBamboBuildNumber() >= 2101) {
            this.executeBuildNewApi(planKey);
        } else {
            this.executeBuildOldApi(planKey);
        }
    }

    private void executeBuildOldApi(String planKey) throws RemoteApiException {
        String buildResultUrl = String.valueOf(this.getBaseUrl()) + EXECUTE_BUILD_ACTION + "?auth=" + UrlUtil.encodeUrl(this.authToken) + "&buildKey=" + UrlUtil.encodeUrl(planKey);
        try {
            Document doc = this.retrieveGetResponse(buildResultUrl);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiException(exception);
            }
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    private void executeBuildNewApi(String planKey) throws RemoteApiException {
        String url = String.valueOf(this.getBaseUrl()) + BUILD_QUEUE_SERVICE + UrlUtil.encodeUrl(planKey);
        try {
            this.retrievePostResponse(url, "", false);
        }
        catch (JDOMException e) {
            throw new RemoteApiException("Server returned malformed response", e);
        }
    }

    BambooBuildInfo.Builder constructBuildErrorInfo(String planKey, String message, Date lastPollingTime) {
        return new BambooBuildInfo.Builder(planKey, null, this.serverData, null, null, BuildStatus.UNKNOWN).pollingTime(lastPollingTime).errorMessage(message);
    }

    BambooBuildInfo.Builder constructBuildErrorInfo(String planKey, String message, Throwable exception, Date lastPollingTime) {
        return new BambooBuildInfo.Builder(planKey, null, this.serverData, null, null, BuildStatus.UNKNOWN).pollingTime(lastPollingTime).errorMessage(message, exception);
    }

    private int parseInt(String number) throws RemoteApiException {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            throw new RemoteApiException("Invalid number", ex);
        }
    }

    private double parseDouble(String number) throws RemoteApiException {
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException ex) {
            throw new RemoteApiException("Invalid double", ex);
        }
    }

    private BambooPlan constructPlanItem(Element planNode, boolean isEnabledDefault) throws RemoteApiException {
        String name = planNode.getAttributeValue("name");
        String key = planNode.getAttributeValue("key");
        String projectName = planNode.getChildText("projectName");
        String projectKey = planNode.getChildText("projectKey");
        boolean isFavourite = Boolean.parseBoolean(planNode.getChildText("isFavourite"));
        Integer averageBuildTime = new Double(this.parseDouble(planNode.getChildText("averageBuildTimeInSeconds"))).intValue();
        boolean isInQueue = Boolean.parseBoolean(planNode.getChildText("isInBuildQueue"));
        String isBuildingString = planNode.getChildText("isBuilding");
        if (isBuildingString == null && isInQueue) {
            isBuildingString = "true";
        }
        boolean isBuilding = Boolean.parseBoolean(isBuildingString);
        String isEnabledString = planNode.getAttributeValue("enabled");
        if (isEnabledString == null) {
            isEnabledString = Boolean.toString(isEnabledDefault);
        }
        boolean isEnabled = Boolean.parseBoolean(isEnabledString);
        return new BambooPlan(name, key, null, isEnabled, isFavourite, projectName, projectKey, averageBuildTime, isInQueue, isBuilding);
    }

    private BambooBuildInfo.Builder constructBuilderItem(Element buildItemNode, Date lastPollingTime, String aPlanKey, Set<String> commiters, int timezoneOffset) throws RemoteApiException {
        BambooBuildInfo.Builder builder;
        if (!buildItemNode.getChildren().iterator().hasNext()) {
            builder = new BambooBuildInfo.Builder(aPlanKey, this.serverData, BuildStatus.UNKNOWN).pollingTime(lastPollingTime).reason("Never built");
        } else {
            String planKey = this.getChildText(buildItemNode, "buildKey");
            String buildName = this.getChildText(buildItemNode, "buildName");
            String projectName = this.getChildText(buildItemNode, "projectName");
            int buildNumber = this.parseInt(this.getChildText(buildItemNode, "buildNumber"));
            String relativeBuildDate = this.getChildText(buildItemNode, "buildRelativeBuildDate");
            Date startTime = this.parseBuildDate(this.getChildText(buildItemNode, "buildTime"), CANNOT_PARSE_BUILD_TIME, timezoneOffset);
            String buildCompletedDateStr = this.getChildText(buildItemNode, BUILD_COMPLETED_DATE_ELEM);
            Date completionTime = buildCompletedDateStr != null && buildCompletedDateStr.length() > 0 ? this.parseDateUniversal(buildCompletedDateStr, BUILD_COMPLETED_DATE_ELEM, timezoneOffset) : startTime;
            String durationDescription = this.getChildText(buildItemNode, "buildDurationDescription");
            String stateStr = this.getChildText(buildItemNode, "buildState");
            builder = new BambooBuildInfo.Builder(planKey, buildName, this.serverData, projectName, buildNumber, this.getStatus(stateStr)).pollingTime(lastPollingTime).reason(this.getChildText(buildItemNode, "buildReason")).startTime(startTime).testSummary(this.getChildText(buildItemNode, "buildTestSummary")).commitComment(this.getChildText(buildItemNode, "buildCommitComment")).testsPassedCount(this.parseInt(this.getChildText(buildItemNode, "successfulTestCount"))).testsFailedCount(this.parseInt(this.getChildText(buildItemNode, "failedTestCount"))).completionTime(completionTime).relativeBuildDate(relativeBuildDate).durationDescription(durationDescription).commiters(commiters);
        }
        return builder;
    }

    private BambooBuildInfo.Builder constructBuilderItem_40(Element buildItemNode, Date lastPollingTime, String aPlanKey, Set<String> commiters, int timezoneOffset) throws RemoteApiException {
        BambooBuildInfo.Builder builder;
        if (!buildItemNode.getChildren().iterator().hasNext()) {
            builder = new BambooBuildInfo.Builder(aPlanKey, this.serverData, BuildStatus.UNKNOWN).pollingTime(lastPollingTime).reason("Never built");
        } else {
            String planKey = aPlanKey;
            String buildName = this.getChildText(buildItemNode, "planName");
            String projectName = this.getChildText(buildItemNode, "projectName");
            int buildNumber = this.parseInt(buildItemNode.getAttributeValue("number"));
            String relativeBuildDate = this.getChildText(buildItemNode, "buildRelativeTime");
            Date startTime = this.parseNewApiBuildTime(this.getChildText(buildItemNode, "buildStartedTime"));
            Date completionTime = this.parseNewApiBuildTime(this.getChildText(buildItemNode, "buildCompletedTime"));
            String durationDescription = this.getChildText(buildItemNode, "buildDurationDescription");
            String stateStr = buildItemNode.getAttributeValue("state");
            builder = new BambooBuildInfo.Builder(planKey, buildName, this.serverData, projectName, buildNumber, this.getStatus(stateStr)).pollingTime(lastPollingTime).reason(this.getBuildReason_40(this.getChildText(buildItemNode, "buildReason"))).startTime(startTime).testSummary(this.getChildText(buildItemNode, "buildTestSummary")).commitComment(this.getChildText(buildItemNode, "buildCommitComment")).testsPassedCount(this.parseInt(this.getChildText(buildItemNode, "successfulTestCount"))).testsFailedCount(this.parseInt(this.getChildText(buildItemNode, "failedTestCount"))).completionTime(completionTime).relativeBuildDate(relativeBuildDate).durationDescription(durationDescription).commiters(commiters);
        }
        return builder;
    }

    private String getBuildReason_40(String reasonOriginal) {
        Pattern pattern = Pattern.compile("(.*)<a([^>]+)>(.+)</a>");
        Matcher m = pattern.matcher(reasonOriginal);
        if (m.find()) {
            return StringEscapeUtils.unescapeHtml((String)(String.valueOf(m.group(1)) + m.group(3)));
        }
        return reasonOriginal;
    }

    private BambooBuild constructBuildItemFromNewApi(Element el, Date pollingTime, String planKey) throws RemoteApiException {
        BambooPlan plan = this.getPlanDetails(planKey);
        BambooBuildInfo.Builder builder = new BambooBuildInfo.Builder(planKey, plan.getName(), this.serverData, plan.getProjectName(), this.parseInt(el.getAttributeValue("number")), this.getStatus(el.getAttributeValue("state")));
        builder.testsFailedCount(this.parseInt(this.getChildText(el, "failedTestCount")));
        builder.testsPassedCount(this.parseInt(this.getChildText(el, "successfulTestCount")));
        builder.startTime(this.parseNewApiBuildTime(this.getChildText(el, "buildStartedTime")));
        builder.completionTime(this.parseNewApiBuildTime(this.getChildText(el, "buildCompletedTime")));
        builder.durationDescription(this.getChildText(el, "buildDurationDescription"));
        builder.reason(this.getChildText(el, "buildReason"));
        builder.pollingTime(pollingTime);
        builder.planState(plan.getState());
        return builder.build();
    }

    @NotNull
    private BuildStatus getStatus(@Nullable String stateStr) {
        if (BUILD_SUCCESSFUL.equalsIgnoreCase(stateStr)) {
            return BuildStatus.SUCCESS;
        }
        if (BUILD_FAILED.equalsIgnoreCase(stateStr)) {
            return BuildStatus.FAILURE;
        }
        return BuildStatus.UNKNOWN;
    }

    private Date parseDateUniversal(@Nullable String dateStr, @NotNull String element, int timezoneOffset) throws RemoteApiException {
        if (dateStr != null) {
            if (dateStr.indexOf(84) != -1) {
                return this.parseCommitTime(dateStr);
            }
            return this.parseBuildDate(dateStr, "Cannot parse " + element, timezoneOffset);
        }
        throw new RemoteApiException(String.valueOf(element) + " cannot be found");
    }

    @Nullable
    private Date parseBuildDate(String date, String errorMessage, int timezoneOffset) {
        try {
            DateTime dateTime = buildDateFormat.parseDateTime(date);
            return dateTime.plusHours(timezoneOffset).toDate();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LoggerImpl.getInstance().debug("Cannot parse build date: " + errorMessage);
            return null;
        }
    }

    private Date parseCommitTime(String date) throws RemoteApiException {
        try {
            return commitDateFormat.parseDateTime(date).toDate();
        }
        catch (IllegalArgumentException e) {
            throw new RemoteApiException("Cannot parse date/time string [" + date + "]", e);
        }
    }

    private Date parseNewApiBuildTime(String dateTime) throws RemoteApiException {
        try {
            return newApiDateFormat.parseDateTime(dateTime).toDate();
        }
        catch (IllegalArgumentException e) {
            throw new RemoteApiException("Cannot parse date/time string [" + dateTime + "]", e);
        }
    }

    private String getChildText(Element node, String childName) {
        Element child = node.getChild(childName);
        if (child == null) {
            return "";
        }
        return child.getText();
    }

    @Override
    public String getBuildLogs(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        String buildResultUrl = null;
        if (this.getBamboBuildNumber() > 1904) {
            List<BambooJobImpl> jobs = this.getJobsForPlan(planKey);
            if (jobs.size() > 1) {
                throw new RemoteApiException("Logs are only available for Plans with a single Job.");
            }
            if (jobs.size() == 1 && jobs.get(0).isEnabled()) {
                String jobKey = jobs.get(0).getKey();
                buildResultUrl = this.getBaseUrl() + "/download/" + jobKey + "/build_logs/" + jobKey + "-" + buildNumber + ".log";
            }
        } else {
            buildResultUrl = this.getBaseUrl() + "/download/" + UrlUtil.encodeUrl(planKey) + "/build_logs/" + UrlUtil.encodeUrl(planKey) + "-" + buildNumber + ".log";
        }
        if (buildResultUrl != null && buildResultUrl.length() > 0) {
            try {
                return this.doUnconditionalGetForTextNonXmlResource(buildResultUrl);
            }
            catch (IOException e) {
                throw new RemoteApiException(e.getMessage(), e);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<String> getBranchKeys(String planKey, boolean useFavourites, boolean myBranchesOnly) throws RemoteApiException {
        ArrayList branches = Lists.newArrayList();
        String my = myBranchesOnly ? "&my" : "";
        String url = String.valueOf(this.getBaseUrl()) + PLAN_STATE + UrlUtil.encodeUrl(planKey) + "?expand=branches.branch" + my;
        try {
            Document doc = this.retrieveGetResponse(url);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiException(exception);
            }
            XPath xpath = XPath.newInstance((String)"/plan/branches/branch");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null) {
                for (Element element : elements) {
                    String favourite;
                    if (useFavourites && StringUtils.equals((String)(favourite = this.getChildText(element, "isFavourite")), (String)"false")) continue;
                    String branchKey = element.getAttributeValue("key");
                    branches.add(branchKey);
                }
            }
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
        return branches;
    }

    @Override
    public List<BambooJobImpl> getJobsForPlan(String planKey) throws RemoteApiException {
        ArrayList<BambooJobImpl> jobs = new ArrayList<BambooJobImpl>();
        String url = String.valueOf(this.getBaseUrl()) + PLAN_STATE + UrlUtil.encodeUrl(planKey) + "?expand=stages.stage.plans";
        try {
            Document doc = this.retrieveGetResponse(url);
            String exception = BambooSessionImpl.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiException(exception);
            }
            XPath xpath = XPath.newInstance((String)"/plan/stages/stage/plans/plan");
            List elements = xpath.selectNodes((Object)doc);
            if (elements != null) {
                for (Element element : elements) {
                    String key = element.getAttributeValue("key");
                    String shortKey = element.getAttributeValue("shortKey");
                    String name = element.getAttributeValue("name");
                    String shortName = element.getAttributeValue("shortName");
                    BambooJobImpl job = new BambooJobImpl(key, shortKey, name, shortName);
                    String enabled = element.getAttributeValue("enabled");
                    if (enabled != null && enabled.equalsIgnoreCase("false")) {
                        job.setEnabled(false);
                    } else {
                        job.setEnabled(true);
                    }
                    jobs.add(job);
                }
            }
            return jobs;
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    @Override
    public Collection<BuildIssue> getIssuesForBuild(@NotNull String planKey, int buildNumber) throws RemoteApiException {
        int bambooBuild = this.getBamboBuildNumber();
        if (bambooBuild < 1401) {
            throw new RemoteApiBadServerVersionException("Bamboo build 1401 or newer required");
        }
        String planUrl = String.valueOf(this.getBaseUrl()) + (bambooBuild <= 1904 ? GET_BUILD_ACTION : "/rest/api/latest/result/") + UrlUtil.encodeUrl(String.valueOf(planKey) + "-" + buildNumber) + GET_ISSUES_SUFFIX + "&auth=" + UrlUtil.encodeUrl(this.authToken);
        try {
            List jiraIssuesNode;
            Document doc = this.retrieveGetResponse(planUrl);
            ArrayList<BuildIssue> issues = new ArrayList<BuildIssue>();
            List list = jiraIssuesNode = bambooBuild <= 1904 ? XPath.newInstance((String)"build/jiraIssues").selectNodes((Object)doc) : XPath.newInstance((String)"result/jiraIssues").selectNodes((Object)doc);
            if (jiraIssuesNode == null) {
                throw new RemoteApiException(INVALID_SERVER_RESPONSE);
            }
            if (jiraIssuesNode.size() != 1) {
                throw new RemoteApiException(INVALID_SERVER_RESPONSE);
            }
            List issuesNodes = XPath.newInstance((String)"issue").selectNodes(jiraIssuesNode.get(0));
            if (issuesNodes == null) {
                throw new RemoteApiException(INVALID_SERVER_RESPONSE);
            }
            for (Element element : issuesNodes) {
                Element url = element.getChild("url");
                if (url == null) {
                    LoggerImpl.getInstance().error("getIssuesForBuild: \"url\" node of the \"issue\" element is null");
                    continue;
                }
                BuildIssueInfo issue = new BuildIssueInfo(element.getAttributeValue("key"), url.getAttributeValue("href"));
                issues.add(issue);
            }
            return issues;
        }
        catch (JDOMException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RemoteApiException(e.getMessage(), e);
        }
    }

    @Override
    @NotNull
    public Collection<BambooPlan> getPlanList() throws RemoteApiException {
        List<BambooPlan> plans = this.getBamboBuildNumber() >= 2906 ? this.listPlanNames_40() : this.listPlanNames();
        try {
            List<String> favPlans = this.getBamboBuildNumber() > 1904 ? this.getFavouriteUserPlansNew() : this.getFavouriteUserPlans();
            block2: for (String fav : favPlans) {
                ListIterator<BambooPlan> it = plans.listIterator();
                while (it.hasNext()) {
                    BambooPlan plan = it.next();
                    if (!plan.getKey().equalsIgnoreCase(fav)) continue;
                    it.set(plan.withFavourite(true));
                    continue block2;
                }
            }
        }
        catch (RemoteApiException remoteApiException) {}
        return plans;
    }

    @Override
    @NotNull
    public Collection<BambooBuild> getSubscribedPlansResults(Collection<SubscribedPlan> plans, boolean isUseFavourities, int timezoneOffset) throws RemoteApiLoginException {
        ArrayList<BambooBuild> builds;
        block11: {
            RemoteApiException exception;
            Collection<BambooPlan> plansForServer;
            block10: {
                builds = new ArrayList<BambooBuild>();
                plansForServer = null;
                exception = null;
                try {
                    plansForServer = this.getPlanList();
                }
                catch (RemoteApiException e) {
                    this.loger.warn("Cannot fetch plan list from Bamboo server [" + BambooSessionImpl.getUrl() + "]");
                    exception = e;
                }
                if (!isUseFavourities) break block10;
                if (plansForServer == null) break block11;
                for (BambooPlan bambooPlan : plansForServer) {
                    if (!bambooPlan.isFavourite()) continue;
                    if (this.isLoggedIn()) {
                        try {
                            BambooBuildInfo buildInfo = this.getLatestBuildBuilderForPlan(bambooPlan.getKey(), timezoneOffset).enabled(bambooPlan.isEnabled()).build();
                            builds.add(buildInfo);
                        }
                        catch (RemoteApiException remoteApiException) {
                            this.loger.warn("Cannot fetch latest build for plan [" + bambooPlan.getKey() + "] from Bamboo server [" + BambooSessionImpl.getUrl() + "]");
                        }
                        continue;
                    }
                    builds.add(this.constructBuildErrorInfo(bambooPlan.getKey(), exception == null ? "" : exception.getMessage(), exception, new Date()).build());
                }
                break block11;
            }
            for (SubscribedPlan plan : plans) {
                if (this.isLoggedIn()) {
                    try {
                        Boolean isEnabled = plansForServer != null ? BambooSessionImpl.isPlanEnabled(plansForServer, plan.getKey()) : null;
                        BambooBuildInfo buildInfo = this.getLatestBuildBuilderForPlan(plan.getKey(), timezoneOffset).enabled(isEnabled != null ? isEnabled : true).build();
                        builds.add(buildInfo);
                    }
                    catch (RemoteApiException remoteApiException) {}
                    continue;
                }
                builds.add(this.constructBuildErrorInfo(plan.getKey(), exception == null ? "" : exception.getMessage(), exception, new Date()).build());
            }
        }
        return builds;
    }
}

