/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.bamboo;

import com.atlassian.theplugin.commons.bamboo.PlanState;
import java.io.Serializable;

public class BambooPlan
implements Serializable {
    private final String name;
    private final String key;
    private final String materPlanKey;
    private final boolean favourite;
    private final boolean enabled;
    private final String projectName;
    private final String projectKey;
    private final Integer averageBuildTime;
    private final PlanState state;

    public BambooPlan(String name, String key, String masterPlanKey) {
        this(name, key, masterPlanKey, true);
    }

    public BambooPlan(String name, String key, String masterPlanKey, boolean isEnabled) {
        this(name, key, masterPlanKey, isEnabled, false);
    }

    public BambooPlan(String name, String key, String masterPlanKey, boolean isEnabled, boolean isFavourite) {
        this(name, key, masterPlanKey, isEnabled, isFavourite, "", "", null, false, false);
    }

    public BambooPlan(String name, String key, String masterPlanKey, boolean isEnabled, Boolean isFavourite, String projectName, String projectKey, Integer averageBuildTime, boolean inQueue, boolean building) {
        this.name = name;
        this.key = key;
        this.materPlanKey = masterPlanKey;
        this.enabled = isEnabled;
        this.favourite = isFavourite;
        this.projectName = projectName;
        this.projectKey = projectKey;
        this.averageBuildTime = averageBuildTime;
        this.state = building ? PlanState.BUILDING : (inQueue ? PlanState.IN_QUEUE : PlanState.STANDING);
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getMaterPlanKey() {
        return this.materPlanKey;
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public BambooPlan withFavourite(boolean isFavourite) {
        return new BambooPlan(this.name, this.key, this.materPlanKey, this.enabled, isFavourite);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public Integer getAverageBuildTime() {
        return this.averageBuildTime;
    }

    public PlanState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BambooPlan)) {
            return false;
        }
        BambooPlan that = (BambooPlan)o;
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }
}

