/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.osgi.util.NLS;
import org.springframework.ide.eclipse.maven.MavenCorePlugin;
import org.springsource.ide.eclipse.commons.configurator.ConfigurableExtension;
import org.springsource.ide.eclipse.commons.configurator.WorkspaceLocationConfiguratorParticipant;

public class MavenRuntimeWorkspaceConfigurator
extends WorkspaceLocationConfiguratorParticipant {
    public String getPath() {
        return "maven-";
    }

    public String[] getPaths() {
        return new String[]{this.getPath(), "apache-maven-"};
    }

    public String getVersionRange() {
        return "[2.2.0,3.1.0)";
    }

    protected ConfigurableExtension doCreateExtension(File location, IProgressMonitor monitor) {
        if (MavenCorePlugin.IS_M2ECLIPSE_PRESENT) {
            return new M2EclipseDependentRuntimeExtension(location.getName(), location);
        }
        return null;
    }

    private class M2EclipseDependentRuntimeExtension
    extends ConfigurableExtension {
        private File location;
        private MavenRuntime oldDefaultRuntime;

        public M2EclipseDependentRuntimeExtension(String id, File location) {
            super(id);
            this.location = location;
            this.setLocation(location.getAbsolutePath());
            this.setLabel("Maven Runtime");
            try {
                this.setConfigured(this.isRuntimeConfigured());
            }
            catch (IOException iOException) {}
        }

        public boolean isRuntimeConfigured() throws IOException {
            String path;
            MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
            MavenRuntime runtime = runtimeManager.getRuntime(path = this.location.getCanonicalPath());
            return runtime != null && runtime.isAvailable();
        }

        public IStatus configure(IProgressMonitor monitor) {
            try {
                MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
                String path = this.location.getCanonicalPath();
                MavenRuntime runtime = runtimeManager.getRuntime(path);
                this.oldDefaultRuntime = runtimeManager.getDefaultRuntime();
                if (runtime != null && runtime.isAvailable()) {
                    if (!runtime.equals(this.oldDefaultRuntime)) {
                        runtimeManager.setDefaultRuntime(runtime);
                    }
                    this.setConfigured(true);
                    return new Status(1, "org.springframework.ide.eclipse.maven", NLS.bind((String)"Maven already configured at {0}", (Object)path));
                }
                runtime = MavenRuntimeManager.createExternalRuntime((String)this.location.getCanonicalPath());
                List runtimes = runtimeManager.getMavenRuntimes();
                runtimes.add(runtime);
                runtimeManager.setRuntimes(runtimes);
                runtimeManager.setDefaultRuntime(runtime);
                this.setConfigured(true);
                return new Status(0, "org.springframework.ide.eclipse.maven", NLS.bind((String)"Maven successfully configured at {0}", (Object)this.location));
            }
            catch (Exception e) {
                MavenCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.maven", 1, e.getMessage(), (Throwable)e));
                return new Status(4, "org.springframework.ide.eclipse.maven", "Unexpected error during Maven runtime configuration", (Throwable)e);
            }
        }

        public IStatus unConfigure(IProgressMonitor monitor) {
            try {
                MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
                String path = this.location.getCanonicalPath();
                MavenRuntime runtime = runtimeManager.getRuntime(path);
                if (runtime != null) {
                    List runtimes = runtimeManager.getMavenRuntimes();
                    runtimes.remove(runtime);
                    runtimeManager.setRuntimes(runtimes);
                }
                if (this.oldDefaultRuntime != null) {
                    runtimeManager.setDefaultRuntime(this.oldDefaultRuntime);
                }
            }
            catch (Exception e) {
                MavenCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.maven", 1, e.getMessage(), (Throwable)e));
            }
            return new Status(0, "org.springframework.ide.eclipse.maven", NLS.bind((String)"Maven successfully unconfigured at {0}", (Object)this.location));
        }
    }
}

