/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.model.IMapping;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;

public class MappingEditorDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IMapping property;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MappingEditorDialog.this.handleButtonPressed((Button)e.widget);
        }
    };
    private Label sourceLabel;
    private Text sourceText;
    private Label targetLabel;
    private Text targetText;
    private Label targetCollectionLabel;
    private Text targetCollectionText;
    private Label fromLabel;
    private Text fromText;
    private Label toLabel;
    private Text toText;
    private Label requiredLabel;
    private Combo requiredText;
    private Button okButton;
    private Button fromBrowseType;
    private Button toBrowseType;

    public MappingEditorDialog(Shell parentShell, IMapping state) {
        super(parentShell);
        this.property = state;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.property.setSource(this.trimString(this.sourceText.getText()));
            this.property.setTarget(this.trimString(this.targetText.getText()));
            this.property.setTargetCollection(this.trimString(this.targetCollectionText.getText()));
            this.property.setFrom(this.trimString(this.fromText.getText()));
            this.property.setTo(this.trimString(this.toText.getText()));
            if (this.requiredText.getText() != null) {
                this.property.setRequired(Boolean.valueOf(this.trimString(this.requiredText.getText())).booleanValue());
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.sourceText.setFocus();
        if (this.property != null && this.property.getSource() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite nameGroup = new Composite(composite, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 3;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.sourceLabel = new Label(nameGroup, 0);
        this.sourceLabel.setText("Source");
        this.sourceText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getSource() != null) {
            this.sourceText.setText(this.property.getSource());
        }
        this.sourceText.setLayoutData((Object)new GridData(768));
        this.sourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingEditorDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        this.targetLabel = new Label(nameGroup, 0);
        this.targetLabel.setText("Target");
        this.targetText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getTarget() != null) {
            this.targetText.setText(this.property.getTarget());
        }
        this.targetText.setLayoutData((Object)new GridData(768));
        this.targetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingEditorDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        this.targetCollectionLabel = new Label(nameGroup, 0);
        this.targetCollectionLabel.setText("Target Collection");
        this.targetCollectionText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getTargetCollection() != null) {
            this.targetCollectionText.setText(this.property.getTargetCollection());
        }
        this.targetCollectionText.setLayoutData((Object)new GridData(768));
        this.targetCollectionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingEditorDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        this.fromLabel = new Label(nameGroup, 0);
        this.fromLabel.setText("From");
        this.fromText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getFrom() != null) {
            this.fromText.setText(this.property.getFrom());
        }
        this.fromText.setLayoutData((Object)new GridData(768));
        this.fromText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingEditorDialog.this.validateInput();
            }
        });
        this.fromBrowseType = new Button(nameGroup, 8);
        this.fromBrowseType.setText("...");
        this.fromBrowseType.setLayoutData((Object)new GridData(128));
        this.fromBrowseType.addSelectionListener(this.buttonListener);
        this.toLabel = new Label(nameGroup, 0);
        this.toLabel.setText("To");
        this.toText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getTo() != null) {
            this.toText.setText(this.property.getTo());
        }
        this.toText.setLayoutData((Object)new GridData(768));
        this.toText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingEditorDialog.this.validateInput();
            }
        });
        this.toBrowseType = new Button(nameGroup, 8);
        this.toBrowseType.setText("...");
        this.toBrowseType.setLayoutData((Object)new GridData(128));
        this.toBrowseType.addSelectionListener(this.buttonListener);
        this.requiredLabel = new Label(nameGroup, 0);
        this.requiredLabel.setText("Required");
        this.requiredText = new Combo(nameGroup, 12);
        this.requiredText.setItems(new String[]{"", "true", "false"});
        if (this.property != null) {
            this.requiredText.setText(Boolean.toString(this.property.getRequired()));
        }
        this.requiredText.setLayoutData((Object)new GridData(768));
        this.requiredText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingEditorDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        MappingEditorDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    public String getId() {
        return this.sourceText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.properties_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the property";
    }

    protected String getShellTitle() {
        return "Property";
    }

    protected String getTitle() {
        return "Property properties";
    }

    private void handleButtonPressed(Button button) {
        IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)new ProgressMonitorDialog(this.getShell()), searchScope, 5);
        dialog.setMessage("Select an type");
        dialog.setBlockOnOpen(true);
        dialog.setTitle("Type Selection");
        if (dialog.open() == 0) {
            IType obj = (IType)dialog.getFirstResult();
            this.requiredText.setText(obj.getFullyQualifiedName());
        }
        this.validateInput();
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    @Override
    public void validateInput() {
        String id = this.sourceText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid name is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

